/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import org.javers.common.validation.Validate;

public class JsonConverter {
    private Gson gson;

    JsonConverter(Gson gson) {
        Validate.argumentsAreNotNull(gson);
        this.gson = gson;
    }

    public String toJson(Object value) {
        return this.gson.toJson(value);
    }

    public JsonElement toJsonElement(Object value) {
        return this.gson.toJsonTree(value);
    }

    public <T> T fromJson(String json, Class<T> expectedType) {
        return (T)this.gson.fromJson(json, expectedType);
    }

    public JsonElement fromJsonToJsonElement(String json) {
        return (JsonElement)this.gson.fromJson(json, JsonElement.class);
    }

    public Object fromJson(String json, Type expectedType) {
        return this.gson.fromJson(json, expectedType);
    }

    public <T> T fromJson(JsonElement json, Class<T> expectedType) {
        return (T)this.gson.fromJson(json, expectedType);
    }
}

