/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.commit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.json.JsonTypeAdapterTemplate;
import org.javers.core.json.typeadapter.commit.CdoSnapshotStateDeserializer;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.type.DuckType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;

class CdoSnapshotTypeAdapter
extends JsonTypeAdapterTemplate<CdoSnapshot> {
    static final String GLOBAL_CDO_ID = "globalId";
    static final String COMMIT_METADATA = "commitMetadata";
    static final String STATE_NAME = "state";
    static final String INITIAL_NAME_LEGACY = "initial";
    static final String TYPE_NAME = "type";
    static final String CHANGED_NAME = "changedProperties";
    private TypeMapper typeMapper;

    public CdoSnapshotTypeAdapter(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    public Class getValueType() {
        return CdoSnapshot.class;
    }

    @Override
    public CdoSnapshot fromJson(JsonElement json, JsonDeserializationContext context) {
        JsonObject jsonObject = (JsonObject)json;
        JsonObject stateObject = (JsonObject)jsonObject.get(STATE_NAME);
        GlobalId cdoId = (GlobalId)context.deserialize(jsonObject.get(GLOBAL_CDO_ID), GlobalId.class);
        DuckType duckType = new DuckType(cdoId.getTypeName(), this.extractPropertyNames(stateObject));
        ManagedType managedType = this.typeMapper.getJaversManagedType(duckType, ManagedType.class);
        CdoSnapshotBuilder builder = CdoSnapshotBuilder.cdoSnapshot(cdoId, managedType);
        this.deserializeType(jsonObject, builder);
        CdoSnapshotState snapshotState = this.deserializeSnapshotState(context, stateObject, managedType);
        CommitMetadata commitMetadata = (CommitMetadata)context.deserialize(((JsonObject)json).get(COMMIT_METADATA), CommitMetadata.class);
        List<String> changedProperties = this.deserializeChangedProperties(jsonObject, context);
        return builder.withState(snapshotState).withCommitMetadata(commitMetadata).withChangedProperties(changedProperties).build();
    }

    private CdoSnapshotState deserializeSnapshotState(JsonDeserializationContext context, JsonObject stateObject, ManagedType managedType) {
        CdoSnapshotStateDeserializer stateDeserializer = new CdoSnapshotStateDeserializer(this.typeMapper, context);
        return stateDeserializer.deserialize((JsonElement)stateObject, managedType);
    }

    private Set<String> extractPropertyNames(JsonObject state) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (Map.Entry entry : state.entrySet()) {
            propertyNames.add((String)entry.getKey());
        }
        return propertyNames;
    }

    private List<String> deserializeChangedProperties(JsonObject jsonObject, JsonDeserializationContext context) {
        JsonElement propsElement = jsonObject.get(CHANGED_NAME);
        if (propsElement == null) {
            return Collections.emptyList();
        }
        return (List)context.deserialize(propsElement, List.class);
    }

    private void deserializeType(JsonObject jsonObject, CdoSnapshotBuilder builder) {
        JsonElement initial = jsonObject.get(INITIAL_NAME_LEGACY);
        if (initial != null) {
            builder.withInitial(initial.getAsBoolean());
            return;
        }
        JsonElement type = jsonObject.get(TYPE_NAME);
        if (type != null) {
            builder.withType(SnapshotType.valueOf(type.getAsString()));
        }
    }

    @Override
    public JsonElement toJson(CdoSnapshot snapshot, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(COMMIT_METADATA, context.serialize((Object)snapshot.getCommitMetadata()));
        jsonObject.add(GLOBAL_CDO_ID, context.serialize((Object)snapshot.getGlobalId()));
        jsonObject.add(STATE_NAME, context.serialize((Object)snapshot.getState()));
        jsonObject.add(CHANGED_NAME, context.serialize(snapshot.getChanged()));
        jsonObject.add(TYPE_NAME, context.serialize((Object)snapshot.getType().name()));
        return jsonObject;
    }
}

