/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import org.javers.common.validation.Validate;
import org.javers.repository.api.QueryParams;
import org.joda.time.LocalDateTime;

public class QueryParamsBuilder {
    private int limit;
    private LocalDateTime from;
    private LocalDateTime to;

    private QueryParamsBuilder(int limit) {
        this.limit = limit;
    }

    public static QueryParamsBuilder withLimit(int limit) {
        QueryParamsBuilder.checkLimit(limit);
        return new QueryParamsBuilder(limit);
    }

    public static QueryParamsBuilder initializeWith(QueryParams queryParams) {
        Validate.argumentIsNotNull(queryParams);
        QueryParamsBuilder builder = QueryParamsBuilder.withLimit(queryParams.limit());
        if (queryParams.from().isPresent()) {
            builder = builder.from(queryParams.from().get());
        }
        if (queryParams.to().isPresent()) {
            builder = builder.to(queryParams.to().get());
        }
        return builder;
    }

    public QueryParamsBuilder limit(int limit) {
        QueryParamsBuilder.checkLimit(limit);
        this.limit = limit;
        return this;
    }

    public QueryParamsBuilder from(LocalDateTime from) {
        this.from = from;
        return this;
    }

    public QueryParamsBuilder to(LocalDateTime to) {
        this.to = to;
        return this;
    }

    private static void checkLimit(int limit) {
        Validate.argumentCheck(limit > 0, "Limit is not a positive number.");
    }

    public QueryParams build() {
        return new QueryParams(this.limit, this.from, this.to);
    }
}

