/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Objects;
import org.javers.common.collections.Defaults;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.metamodel.object.CdoWrapper;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.DehydrateMapFunction;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;

public class SnapshotFactory {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    public SnapshotFactory(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    public CdoSnapshot createTerminal(GlobalId globalId, CommitMetadata commitMetadata) {
        ManagedType managedType = this.typeMapper.getJaversManagedType(globalId);
        return CdoSnapshotBuilder.cdoSnapshot(globalId, commitMetadata, managedType).withType(SnapshotType.TERMINAL).build();
    }

    public CdoSnapshot createInitial(CdoWrapper cdoWrapper, CommitMetadata commitMetadata) {
        return this.createSnapshotState(cdoWrapper, commitMetadata).withType(SnapshotType.INITIAL).markAllAsChanged().withVersion(1L).build();
    }

    public CdoSnapshot createUpdate(CdoWrapper cdoWrapper, CdoSnapshot previous, CommitMetadata commitMetadata) {
        return this.createSnapshotState(cdoWrapper, commitMetadata).withType(SnapshotType.UPDATE).markChanged(previous).withVersion(previous.getVersion() + 1L).build();
    }

    private Object extractAndDehydrateEnumerable(Object propertyVal, EnumerableType propertyType, OwnerContext owner) {
        EnumerableFunction dehydratorMapFunction;
        if (!propertyType.isFullyParametrized()) {
            throw new JaversException(JaversExceptionCode.GENERIC_TYPE_NOT_PARAMETRIZED, propertyType.getBaseJavaType().toString());
        }
        if (propertyType instanceof ContainerType) {
            JaversType itemType = this.typeMapper.getJaversType(((ContainerType)propertyType).getItemClass());
            dehydratorMapFunction = new DehydrateContainerFunction(itemType, this.globalIdFactory);
        } else if (propertyType instanceof MapType) {
            MapContentType mapContentType = this.typeMapper.getMapContentType((MapType)propertyType);
            dehydratorMapFunction = new DehydrateMapFunction(this.globalIdFactory, mapContentType);
        } else {
            throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
        }
        return propertyType.map(propertyVal, dehydratorMapFunction, owner);
    }

    private CdoSnapshotBuilder createSnapshotState(CdoWrapper cdoWrapper, CommitMetadata commitMetadata) {
        CdoSnapshotBuilder snapshotBuilder = CdoSnapshotBuilder.cdoSnapshot(cdoWrapper.getGlobalId(), commitMetadata, cdoWrapper.getManagedType());
        for (Property property : cdoWrapper.getManagedType().getProperties()) {
            Object propertyVal = cdoWrapper.getPropertyValue(property.getName());
            if (Objects.equals(propertyVal, Defaults.defaultValue(property.getGenericType()))) continue;
            snapshotBuilder.withPropertyValue(property, this.dehydrateProperty(property, propertyVal, cdoWrapper.getGlobalId()));
        }
        return snapshotBuilder;
    }

    private Object dehydrateProperty(Property property, Object propertyVal, GlobalId id) {
        Object propertyType = this.typeMapper.getPropertyType(property);
        OwnerContext owner = new OwnerContext(id, property.getName());
        if (propertyType instanceof EnumerableType) {
            return this.extractAndDehydrateEnumerable(propertyVal, (EnumerableType)propertyType, owner);
        }
        return this.globalIdFactory.dehydrate(propertyVal, (JaversType)propertyType, owner);
    }
}

