/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javers.common.collections.Lists;
import org.javers.core.metamodel.annotation.AnnotationsNameSpace;
import org.javers.core.metamodel.annotation.JPAAnnotationsNameSpace;
import org.javers.core.metamodel.annotation.JaversAnnotationsNamesSpace;

public class AnnotationNamesProvider {
    private final Set<String> entityAliases = new HashSet<String>();
    private final Set<String> typeNameAliases = new HashSet<String>();
    private final Set<String> valueObjectAliases = new HashSet<String>();
    private final Set<String> valueAliases = new HashSet<String>();
    private final Set<String> transientPropertyAliases = new HashSet<String>();
    private final List<AnnotationsNameSpace> namesProviders = Lists.immutableListOf(new JaversAnnotationsNamesSpace(), new JPAAnnotationsNameSpace());

    public AnnotationNamesProvider() {
        for (AnnotationsNameSpace provider : this.namesProviders) {
            this.entityAliases.addAll(provider.getEntityAliases());
            this.valueObjectAliases.addAll(provider.getValueObjectAliases());
            this.valueAliases.addAll(provider.getValueAliases());
            this.transientPropertyAliases.addAll(provider.getTransientPropertyAliases());
            this.typeNameAliases.addAll(provider.getTypeNameAliases());
        }
    }

    boolean isTypeName(Annotation ann) {
        return this.typeNameAliases.contains(ann.annotationType().getSimpleName());
    }

    boolean isEntityAlias(Annotation ann) {
        return this.entityAliases.contains(ann.annotationType().getSimpleName());
    }

    boolean isValueObjectAlias(Annotation ann) {
        return this.valueObjectAliases.contains(ann.annotationType().getSimpleName());
    }

    boolean isValueAlias(Annotation ann) {
        return this.valueAliases.contains(ann.annotationType().getSimpleName());
    }

    public Set<String> getTransientAliases() {
        return Collections.unmodifiableSet(this.transientPropertyAliases);
    }
}

