/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;

public class EntityDefinition
extends ClientsClassDefinition {
    private final Optional<String> idPropertyName;

    public EntityDefinition(Class<?> entity) {
        this(new EntityDefinitionBuilder(entity));
    }

    public EntityDefinition(Class<?> entity, String idPropertyName) {
        this(new EntityDefinitionBuilder(entity).withIdPropertyName(idPropertyName));
    }

    private EntityDefinition(EntityDefinitionBuilder builder) {
        super(builder);
        this.idPropertyName = builder.idPropertyName;
    }

    @Deprecated
    public EntityDefinition(Class<?> entity, String idPropertyName, List<String> ignoredProperties) {
        this((EntityDefinitionBuilder)new EntityDefinitionBuilder(entity).withIdPropertyName(idPropertyName).withIgnoredProperties(ignoredProperties));
    }

    public boolean hasCustomId() {
        return this.idPropertyName.isPresent();
    }

    public String getIdPropertyName() {
        return this.idPropertyName.get();
    }

    public static class EntityDefinitionBuilder
    extends ClientsClassDefinition.ClientsClassDefinitionBuilder<EntityDefinitionBuilder> {
        private Optional<String> idPropertyName = Optional.empty();

        private EntityDefinitionBuilder(Class<?> entity) {
            super(entity);
        }

        public static EntityDefinitionBuilder entityDefinition(Class<?> entity) {
            return new EntityDefinitionBuilder(entity);
        }

        public EntityDefinitionBuilder withIdPropertyName(String idPropertyName) {
            Validate.argumentIsNotNull(idPropertyName);
            this.idPropertyName = Optional.of(idPropertyName);
            return this;
        }

        @Override
        public EntityDefinition build() {
            return new EntityDefinition(this);
        }
    }
}

