/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;

public abstract class ClientsClassDefinition {
    private final Class<?> baseJavaClass;
    private final List<String> ignoredProperties;
    private final Optional<String> typeName;

    ClientsClassDefinition(Class<?> baseJavaClass) {
        this(new ClientsClassDefinitionBuilder(baseJavaClass));
    }

    ClientsClassDefinition(Class<?> clazz, List<String> ignoredProperties) {
        this((ClientsClassDefinitionBuilder)new ClientsClassDefinitionBuilder(clazz).withIgnoredProperties(ignoredProperties));
    }

    ClientsClassDefinition(ClientsClassDefinitionBuilder builder) {
        Validate.argumentsAreNotNull(builder);
        this.baseJavaClass = builder.clazz;
        this.ignoredProperties = new ArrayList<String>(builder.ignoredProperties);
        this.typeName = builder.typeName;
    }

    public Class<?> getBaseJavaClass() {
        return this.baseJavaClass;
    }

    public boolean equals(Object o) {
        if (this == o || this.getClass() != o.getClass()) {
            return false;
        }
        ClientsClassDefinition that = (ClientsClassDefinition)o;
        return this.baseJavaClass.equals(that.baseJavaClass);
    }

    public int hashCode() {
        return this.baseJavaClass.hashCode();
    }

    public List<String> getIgnoredProperties() {
        return Collections.unmodifiableList(this.ignoredProperties);
    }

    public Optional<String> getTypeName() {
        return this.typeName;
    }

    public static class ClientsClassDefinitionBuilder<T extends ClientsClassDefinitionBuilder> {
        private Class<?> clazz;
        private List<String> ignoredProperties = Collections.EMPTY_LIST;
        private Optional<String> typeName = Optional.empty();

        ClientsClassDefinitionBuilder(Class<?> clazz) {
            this.clazz = clazz;
        }

        public T withIgnoredProperties(List<String> ignoredProperties) {
            Validate.argumentIsNotNull(ignoredProperties);
            this.ignoredProperties = ignoredProperties;
            return (T)this;
        }

        public T withTypeName(String typeName) {
            Validate.argumentIsNotNull(typeName);
            this.typeName = Optional.of(typeName);
            return (T)this;
        }

        public ClientsClassDefinition build() {
            throw new RuntimeException("not implemented");
        }
    }
}

