/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.javers.common.reflection.JaversMember;
import org.javers.common.string.ToStringBuilder;

public class JaversMethod
extends JaversMember<Method> {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public JaversMethod(Method rawMethod, Type resolvedReturnType) {
        super(rawMethod, resolvedReturnType);
    }

    @Override
    protected Type getRawGenericType() {
        return ((Method)this.getRawMember()).getGenericReturnType();
    }

    @Override
    public Class<?> getType() {
        return ((Method)this.getRawMember()).getReturnType();
    }

    @Override
    public Object invokeEvenIfPrivate(Object onObject) {
        this.setAccessibleIfNecessary();
        try {
            return ((Method)this.getRawMember()).invoke(onObject, EMPTY_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException("error calling getter {" + this.getRawMember() + "}", e);
        }
    }

    @Override
    public String propertyName() {
        return this.getterToField(this.name());
    }

    public String toString() {
        return "Method " + ToStringBuilder.typeName(this.getGenericType()) + " " + this.name() + "; //declared in: " + this.getDeclaringClass().getSimpleName();
    }

    private String getterToField(String getterName) {
        if (getterName.substring(0, 3).equals("get")) {
            return getterName.substring(3, 4).toLowerCase() + getterName.substring(4);
        }
        if (getterName.substring(0, 2).equals("is")) {
            return getterName.substring(2, 3).toLowerCase() + getterName.substring(3);
        }
        throw new IllegalArgumentException("Name {" + getterName + "} is not a getter name");
    }
}

