/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.repository.jql.ClassFilter;
import org.javers.repository.jql.Filter;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.IdFilter;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.PropertyFilter;
import org.javers.repository.jql.ValueObjectIdDTO;
import org.javers.repository.jql.VoOwnerFilter;

public class QueryBuilder {
    private static int DEFAULT_LIMIT = 100;
    private int limit = DEFAULT_LIMIT;
    private boolean newObjectChanges;
    private final List<Filter> filters = new ArrayList<Filter>();

    private QueryBuilder(Filter initialFilter) {
        this.addFilter(initialFilter);
    }

    public static QueryBuilder byClass(Class requiredClass) {
        return new QueryBuilder(new ClassFilter(requiredClass));
    }

    public static QueryBuilder byInstanceId(Object localId, Class entityClass) {
        Validate.argumentsAreNotNull(localId, entityClass);
        return new QueryBuilder(new IdFilter(InstanceIdDTO.instanceId(localId, entityClass)));
    }

    public static QueryBuilder byValueObject(Class ownerEntityClass, String path) {
        Validate.argumentsAreNotNull(ownerEntityClass, path);
        return new QueryBuilder(new VoOwnerFilter(ownerEntityClass, path));
    }

    public static QueryBuilder byValueObjectId(Object ownerLocalId, Class ownerEntityClass, String path) {
        Validate.argumentsAreNotNull(ownerEntityClass, ownerLocalId, path);
        return new QueryBuilder(new IdFilter(ValueObjectIdDTO.valueObjectId(ownerLocalId, ownerEntityClass, path)));
    }

    @Deprecated
    public static QueryBuilder byGlobalIdDTO(GlobalIdDTO globalId) {
        Validate.argumentIsNotNull(globalId);
        return new QueryBuilder(new IdFilter(globalId));
    }

    public QueryBuilder andProperty(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        this.addFilter(new PropertyFilter(propertyName));
        return this;
    }

    public QueryBuilder withNewObjectChanges(boolean newObjectChanges) {
        this.newObjectChanges = newObjectChanges;
        return this;
    }

    public QueryBuilder limit(int limit) {
        this.limit = limit;
        return this;
    }

    protected void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    protected List<Filter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    protected int getLimit() {
        return this.limit;
    }

    public JqlQuery build() {
        if (this.filters.isEmpty()) {
            throw new JaversException(JaversExceptionCode.RUNTIME_EXCEPTION, "empty JqlQuery");
        }
        return new JqlQuery(this.getFilters(), this.newObjectChanges, this.getLimit());
    }
}

