/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders.levenshtein;

import java.util.List;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.levenshtein.Backtrack;
import org.javers.core.diff.appenders.levenshtein.BacktrackSteps;
import org.javers.core.diff.appenders.levenshtein.StepsToChanges;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;

public class LevenshteinListChangeAppender
extends CorePropertyChangeAppender<ListChange> {
    private final Backtrack backtrack = new Backtrack();
    private final StepsToChanges stepsToChanges = new StepsToChanges();

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ListType;
    }

    @Override
    public ListChange calculateChanges(NodePair pair, Property property) {
        List leftList = (List)pair.getLeftPropertyValue(property);
        List rightList = (List)pair.getRightPropertyValue(property);
        BacktrackSteps[][] steps = this.backtrack.evaluateSteps(leftList, rightList);
        List<ContainerElementChange> changes = this.stepsToChanges.convert(steps, leftList, rightList);
        return this.getListChange(pair.getGlobalId(), property, changes);
    }

    private ListChange getListChange(GlobalId affectedCdoId, Property property, List<ContainerElementChange> changes) {
        ListChange result = changes.size() == 0 ? null : new ListChange(affectedCdoId, property, changes);
        return result;
    }
}

