/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

public class Primitives {
    private static final Class<?>[] PRIMITIVE_TYPES = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Boolean.TYPE, Character.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class, Character.class};
    private static final Class<?>[] JSON_BASIC_TYPES = new Class[]{Integer.TYPE, Integer.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, String.class};

    public static Class<?>[] getPrimitiveAndBoxTypes() {
        return PRIMITIVE_TYPES;
    }

    public static boolean isJsonBasicType(Object object) {
        if (object == null) {
            return false;
        }
        return Primitives.isJsonBasicType(object.getClass());
    }

    public static boolean isPrimitiveOrBox(Object object) {
        if (object == null) {
            return false;
        }
        return Primitives.isPrimitiveOrBox(object.getClass());
    }

    public static boolean isJsonBasicType(Class clazz) {
        return Primitives.isAssignableFromAny(clazz, JSON_BASIC_TYPES);
    }

    public static boolean isPrimitiveOrBox(Class clazz) {
        return Primitives.isAssignableFromAny(clazz, PRIMITIVE_TYPES);
    }

    private static boolean isAssignableFromAny(Class clazz, Class<?>[] assignableFrom) {
        for (Class<?> standardPrimitive : assignableFrom) {
            if (!standardPrimitive.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

