/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;

public final class CommitId {
    private final long majorId;
    private final int minorId;

    public CommitId(long majorId, int minorId) {
        this.majorId = majorId;
        this.minorId = minorId;
    }

    public static CommitId valueOf(String majorDotMinor) {
        Validate.argumentIsNotNull(majorDotMinor);
        String[] strings = majorDotMinor.split("\\.");
        if (strings.length != 2) {
            throw new JaversException(JaversExceptionCode.CANT_PARSE_COMMIT_ID, majorDotMinor);
        }
        long major = Long.parseLong(strings[0]);
        int minor = Integer.parseInt(strings[1]);
        return new CommitId(major, minor);
    }

    public String toString() {
        return this.value();
    }

    public String value() {
        return this.majorId + "." + this.minorId;
    }

    public long getMajorId() {
        return this.majorId;
    }

    public int getMinorId() {
        return this.minorId;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof CommitId) {
            return this.value().equals(((CommitId)o).value());
        }
        if (o instanceof String) {
            return this.value().equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.value().hashCode();
    }
}

