/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.commit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.type.TypeMapper;

class GlobalIdTypeAdapter
implements JsonTypeAdapter<GlobalId> {
    private static final String ENTITY_FIELD = "entity";
    private static final String CDO_ID_FIELD = "cdoId";
    private static final String OWNER_ID_FIELD = "ownerId";
    private static final String VALUE_OBJECT_FIELD = "valueObject";
    private static final String FRAGMENT_FIELD = "fragment";
    private final GlobalIdFactory globalIdFactory;
    private final TypeMapper typeMapper;

    public GlobalIdTypeAdapter(GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
        this.globalIdFactory = globalIdFactory;
        this.typeMapper = typeMapper;
    }

    @Override
    public GlobalId fromJson(JsonElement json, JsonDeserializationContext context) {
        JsonObject jsonObject = (JsonObject)json;
        if (jsonObject.get(ENTITY_FIELD) != null) {
            return this.parseInstanceId(jsonObject, context);
        }
        if (jsonObject.get(OWNER_ID_FIELD) != null) {
            return this.parseValueObjectId(jsonObject, context);
        }
        return this.parseUnboundedValueObject(jsonObject);
    }

    private UnboundedValueObjectId parseUnboundedValueObject(JsonObject jsonObject) {
        Class valueObjectClass = this.parseClass(jsonObject, VALUE_OBJECT_FIELD);
        return this.globalIdFactory.createFromClass(valueObjectClass);
    }

    private ValueObjectId parseValueObjectId(JsonObject jsonObject, JsonDeserializationContext context) {
        Class valueObjectClass = this.parseClass(jsonObject, VALUE_OBJECT_FIELD);
        String fragment = jsonObject.get(FRAGMENT_FIELD).getAsString();
        InstanceId ownerId = (InstanceId)context.deserialize(jsonObject.get(OWNER_ID_FIELD), InstanceId.class);
        return this.globalIdFactory.createFromPath(ownerId, valueObjectClass, fragment);
    }

    private InstanceId parseInstanceId(JsonObject jsonObject, JsonDeserializationContext context) {
        Entity entity = this.parseEntity(jsonObject, ENTITY_FIELD);
        JsonElement cdoIdElement = jsonObject.get(CDO_ID_FIELD);
        Object cdoId = context.deserialize(cdoIdElement, entity.getIdProperty().getType());
        jsonObject.get(ENTITY_FIELD).getAsString();
        return this.globalIdFactory.createFromId(cdoId, entity);
    }

    @Override
    public JsonElement toJson(GlobalId globalId, JsonSerializationContext context) {
        if (globalId == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (globalId.getCdoClass() instanceof Entity) {
            jsonObject.addProperty(ENTITY_FIELD, globalId.getCdoClass().getName());
        } else {
            jsonObject.addProperty(VALUE_OBJECT_FIELD, globalId.getCdoClass().getName());
        }
        if (globalId.getCdoId() != null) {
            jsonObject.add(CDO_ID_FIELD, context.serialize(globalId.getCdoId()));
        }
        if (globalId instanceof ValueObjectId) {
            ValueObjectId valueObjectId = (ValueObjectId)globalId;
            jsonObject.add(OWNER_ID_FIELD, context.serialize((Object)valueObjectId.getOwnerId()));
            jsonObject.addProperty(FRAGMENT_FIELD, valueObjectId.getFragment());
        }
        return jsonObject;
    }

    @Override
    public List<Class> getValueTypes() {
        return Lists.immutableListOf(GlobalId.class, InstanceId.class, UnboundedValueObjectId.class, ValueObjectId.class);
    }

    private Entity parseEntity(JsonObject object, String fieldName) {
        return this.typeMapper.getManagedClass(this.parseClass(object, fieldName), Entity.class);
    }

    private Class parseClass(JsonObject object, String fieldName) {
        String className = object.get(fieldName).getAsString();
        try {
            this.getClass();
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new JaversException(JaversExceptionCode.CLASS_NOT_FOUND, className);
        }
    }
}

