/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.MapChangeAppender;
import org.javers.core.diff.appenders.MapChangesToListChangesFunction;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListChangeAppender
extends CorePropertyChangeAppender<ListChange> {
    private static final Logger logger = LoggerFactory.getLogger(ListChangeAppender.class);
    private final MapChangeAppender mapChangeAppender;
    private final TypeMapper typeMapper;

    ListChangeAppender(MapChangeAppender mapChangeAppender, TypeMapper typeMapper) {
        this.mapChangeAppender = mapChangeAppender;
        this.typeMapper = typeMapper;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ListType;
    }

    @Override
    public ListChange calculateChanges(NodePair pair, Property property) {
        List leftList = (List)pair.getLeftPropertyValue(property);
        List rightList = (List)pair.getRightPropertyValue(property);
        ListType listType = (ListType)this.typeMapper.getPropertyType(property);
        OwnerContext owner = new OwnerContext(pair.getGlobalId(), property.getName());
        MapContentType mapContentType = this.typeMapper.getMapContentType(listType);
        List<EntryChange> entryChanges = this.mapChangeAppender.calculateEntryChanges(Lists.asMap(leftList), Lists.asMap(rightList), owner, mapContentType);
        if (!entryChanges.isEmpty()) {
            List<ContainerElementChange> elementChanges = Lists.transform(entryChanges, new MapChangesToListChangesFunction());
            return new ListChange(pair.getGlobalId(), property, elementChanges);
        }
        return null;
    }
}

