/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import java.util.Map;
import org.javers.common.collections.Arrays;
import org.javers.common.collections.Lists;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.MapChangeAppender;
import org.javers.core.diff.appenders.MapChangesToListChangesFunction;
import org.javers.core.diff.changetype.container.ArrayChange;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrayChangeAppender
extends CorePropertyChangeAppender<ArrayChange> {
    private static final Logger logger = LoggerFactory.getLogger(ArrayChangeAppender.class);
    private final MapChangeAppender mapChangeAppender;
    private final TypeMapper typeMapper;

    ArrayChangeAppender(MapChangeAppender mapChangeAppender, TypeMapper typeMapper) {
        this.mapChangeAppender = mapChangeAppender;
        this.typeMapper = typeMapper;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ArrayType;
    }

    @Override
    public ArrayChange calculateChanges(NodePair pair, Property property) {
        OwnerContext owner;
        Map leftMap = Arrays.asMap(pair.getLeftPropertyValue(property));
        Map rightMap = Arrays.asMap(pair.getRightPropertyValue(property));
        ArrayType arrayType = (ArrayType)this.typeMapper.getPropertyType(property);
        List<EntryChange> entryChanges = this.mapChangeAppender.calculateEntryChanges(new MapType(arrayType), leftMap, rightMap, owner = new OwnerContext(pair.getGlobalId(), property.getName()));
        if (!entryChanges.isEmpty()) {
            List<ContainerElementChange> elementChanges = Lists.transform(entryChanges, new MapChangesToListChangesFunction());
            return new ArrayChange(pair.getGlobalId(), property, elementChanges);
        }
        return null;
    }
}

