/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import com.google.gson.TypeAdapter;
import java.util.HashSet;
import java.util.Set;
import org.javers.common.validation.Validate;
import org.javers.core.AbstractJaversBuilder;
import org.javers.core.CoreJaversModule;
import org.javers.core.Javers;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.MappingStyle;
import org.javers.core.commit.CommitFactoryModule;
import org.javers.core.diff.DiffFactoryModule;
import org.javers.core.diff.appenders.DiffAppendersModule;
import org.javers.core.diff.custom.CustomPropertyComparator;
import org.javers.core.diff.custom.CustomToNativeAppenderAdapter;
import org.javers.core.json.JsonConverterBuilder;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.change.ChangeTypeAdaptersModule;
import org.javers.core.json.typeadapter.commit.CommitTypeAdaptersModule;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.CustomDefinition;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.clazz.ManagedClassFactoryModule;
import org.javers.core.metamodel.clazz.ValueDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinition;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.snapshot.GraphSnapshotModule;
import org.javers.repository.api.InMemoryRepositoryModule;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.api.JaversRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaversBuilder
extends AbstractJaversBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JaversBuilder.class);
    private final Set<ClientsClassDefinition> clientsClassDefinitions = new HashSet<ClientsClassDefinition>();
    private JaversRepository repository;

    public static JaversBuilder javers() {
        return new JaversBuilder();
    }

    private JaversBuilder() {
        logger.debug("starting up javers ...");
        this.bootContainer();
        this.addModule(new CoreJaversModule(this.getContainer()));
        this.addModule(new DiffAppendersModule(this.getContainer()));
        this.addModule(new DiffFactoryModule());
        this.addModule(new CommitFactoryModule(this.getContainer()));
        this.addModule(new GraphSnapshotModule(this.getContainer()));
    }

    public Javers build() {
        this.bootManagedClasses();
        this.bootJsonConverter();
        this.bootRepository();
        Javers javers = this.getContainerComponent(Javers.class);
        logger.info("javers instance is up & ready");
        return javers;
    }

    public JaversBuilder registerJaversRepository(JaversRepository repository) {
        Validate.argumentsAreNotNull(repository);
        this.repository = repository;
        return this;
    }

    public JaversBuilder registerEntity(Class<?> entityClass) {
        Validate.argumentIsNotNull(entityClass);
        return this.registerEntity(new EntityDefinition(entityClass));
    }

    public JaversBuilder registerEntity(Class<?> entityClass, String idPropertyName) {
        Validate.argumentsAreNotNull(entityClass, idPropertyName);
        return this.registerEntity(new EntityDefinition(entityClass, idPropertyName));
    }

    public JaversBuilder registerValueObject(Class<?> valueObjectClass) {
        Validate.argumentIsNotNull(valueObjectClass);
        this.clientsClassDefinitions.add(new ValueObjectDefinition(valueObjectClass));
        return this;
    }

    public JaversBuilder registerValue(Class<?> valueClass) {
        Validate.argumentIsNotNull(valueClass);
        this.clientsClassDefinitions.add(new ValueDefinition(valueClass));
        return this;
    }

    public JaversBuilder registerValueTypeAdapter(JsonTypeAdapter typeAdapter) {
        for (Class c : typeAdapter.getValueTypes()) {
            this.registerValue(c);
        }
        this.jsonConverterBuilder().registerJsonTypeAdapter(typeAdapter);
        return this;
    }

    public JaversBuilder registerValueGsonTypeAdapter(Class valueType, TypeAdapter nativeAdapter) {
        this.registerValue(valueType);
        this.jsonConverterBuilder().registerNativeTypeAdapter(valueType, nativeAdapter);
        return this;
    }

    public JaversBuilder typeSafeValues() {
        this.jsonConverterBuilder().typeSafeValues(true);
        return this;
    }

    public JaversBuilder registerEntities(Class<?> ... entityClasses) {
        for (Class<?> clazz : entityClasses) {
            this.registerEntity(clazz);
        }
        return this;
    }

    public JaversBuilder registerValueObjects(Class<?> ... valueObjectClasses) {
        for (Class<?> clazz : valueObjectClasses) {
            this.registerValueObject(clazz);
        }
        return this;
    }

    public JaversBuilder withMappingStyle(MappingStyle mappingStyle) {
        Validate.argumentIsNotNull((Object)mappingStyle);
        this.coreConfiguration().withMappingStyle(mappingStyle);
        return this;
    }

    public JaversBuilder withNewObjectsSnapshot(boolean newObjectsSnapshot) {
        this.coreConfiguration().withNewObjectsSnapshot(newObjectsSnapshot);
        return this;
    }

    public <T> JaversBuilder registerCustomComparator(CustomPropertyComparator<T, ?> comparator, Class<T> customType) {
        this.clientsClassDefinitions.add(new CustomDefinition(customType));
        this.addComponent(new CustomToNativeAppenderAdapter(comparator, customType));
        return this;
    }

    private void mapRegisteredClasses() {
        TypeMapper typeMapper = this.typeMapper();
        for (ClientsClassDefinition def : this.clientsClassDefinitions) {
            typeMapper.registerClientsClass(def);
        }
    }

    private TypeMapper typeMapper() {
        return this.getContainerComponent(TypeMapper.class);
    }

    private JaversCoreConfiguration coreConfiguration() {
        return this.getContainerComponent(JaversCoreConfiguration.class);
    }

    private JsonConverterBuilder jsonConverterBuilder() {
        return this.getContainerComponent(JsonConverterBuilder.class);
    }

    private void bootManagedClasses() {
        this.addModule(new ManagedClassFactoryModule(this.coreConfiguration()));
        this.mapRegisteredClasses();
    }

    private void bootJsonConverter() {
        JsonConverterBuilder jsonConverterBuilder = this.jsonConverterBuilder();
        this.addModule(new ChangeTypeAdaptersModule(this.getContainer()));
        this.addModule(new CommitTypeAdaptersModule(this.getContainer()));
        jsonConverterBuilder.registerJsonTypeAdapters(this.getComponents(JsonTypeAdapter.class));
        this.addComponent(jsonConverterBuilder.build());
    }

    private void bootRepository() {
        if (this.repository == null) {
            logger.info("using fake InMemoryRepository, register actual implementation via JaversBuilder.registerJaversRepository()");
            this.addModule(new InMemoryRepositoryModule(this.getContainer()));
        } else {
            this.addComponent(this.repository);
        }
        this.addComponent(JaversExtendedRepository.class);
    }

    private JaversBuilder registerEntity(EntityDefinition entityDefinition) {
        this.clientsClassDefinitions.add(entityDefinition);
        return this;
    }
}

