/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.List;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.pico.InstantiatingModule;
import org.javers.core.pico.JaversModule;
import org.picocontainer.ComponentFactory;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.behaviors.Caching;

public abstract class AbstractJaversBuilder {
    private MutablePicoContainer container;

    protected <T> T getContainerComponent(Class<T> ofClass) {
        this.checkIfBuilt();
        return (T)this.container.getComponent(ofClass);
    }

    protected void bootContainer(JaversModule coreModule) {
        Validate.argumentIsNotNull(coreModule);
        this.container = new DefaultPicoContainer((ComponentFactory)new Caching());
        this.addModule(coreModule);
    }

    protected void addModule(InstantiatingModule module) {
        this.checkIfBuilt();
        module.instantiateAndBindComponents();
    }

    protected void addModule(JaversModule module) {
        this.checkIfBuilt();
        for (Class component : module.getComponents()) {
            this.addComponent(component);
        }
    }

    protected <T> List<T> getComponents(Class<T> ofType) {
        return this.container.getComponents(ofType);
    }

    protected MutablePicoContainer getContainer() {
        return this.container;
    }

    protected void addComponent(Object classOrInstance) {
        this.checkIfBuilt();
        this.container.addComponent(classOrInstance);
    }

    protected void bindComponent(Class bindToInterface, Object implementationOrInstance) {
        this.checkIfBuilt();
        this.container.addComponent((Object)bindToInterface, implementationOrInstance, new Parameter[0]);
    }

    private void checkIfNotBuilt() {
        if (this.isBuilt()) {
            throw new JaversException(JaversExceptionCode.ALREADY_BUILT, new Object[0]);
        }
    }

    private void checkIfBuilt() {
        if (!this.isBuilt()) {
            throw new JaversException(JaversExceptionCode.CONTAINER_NOT_READY, new Object[0]);
        }
    }

    private boolean isBuilt() {
        return this.container != null;
    }
}

