/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClass;
import org.javers.core.metamodel.clazz.ValueObject;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdDTO;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;

public class GlobalIdFactory {
    private final TypeMapper typeMapper;

    public GlobalIdFactory(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public GlobalId createId(Object targetCdo) {
        return this.createId(targetCdo, null);
    }

    public GlobalId createId(Object targetCdo, OwnerContext owner) {
        Validate.argumentsAreNotNull(targetCdo);
        ManagedClass targetManagedClass = this.getManagedClassOf(targetCdo);
        if (targetManagedClass instanceof Entity) {
            return InstanceId.createFromInstance(targetCdo, (Entity)targetManagedClass);
        }
        if (targetManagedClass instanceof ValueObject && this.hasNoOwner(owner)) {
            return new UnboundedValueObjectId((ValueObject)targetManagedClass);
        }
        if (targetManagedClass instanceof ValueObject && this.hasOwner(owner)) {
            return new ValueObjectId((ValueObject)targetManagedClass, owner);
        }
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
    }

    public UnboundedValueObjectId createFromClass(Class valueObjectClass) {
        ValueObject valueObject = this.typeMapper.getManagedClass(valueObjectClass, ValueObject.class);
        return new UnboundedValueObjectId(valueObject);
    }

    public ValueObjectId createFromPath(GlobalId owner, Class valueObjectClass, String path) {
        ValueObject valueObject = this.typeMapper.getManagedClass(valueObjectClass, ValueObject.class);
        return new ValueObjectId(valueObject, owner, path);
    }

    public InstanceId createFromId(Object localId, Entity entity) {
        return InstanceId.createFromId(localId, entity);
    }

    public InstanceId createFromId(Object localId, Class entityClass) {
        Entity entity = this.typeMapper.getManagedClass(entityClass, Entity.class);
        return InstanceId.createFromId(localId, entity);
    }

    public GlobalId createFromDto(GlobalIdDTO idDto) {
        return idDto.create(this.typeMapper);
    }

    public Object dehydrate(Object item, JaversType targetType, OwnerContext context) {
        if (!(item instanceof GlobalId) && targetType instanceof ManagedType) {
            return this.createId(item, context);
        }
        return item;
    }

    private ManagedClass getManagedClassOf(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.typeMapper.getJaversManagedType(cdo.getClass()).getManagedClass();
    }

    private boolean hasOwner(OwnerContext context) {
        return context != null && context.getGlobalId() != null;
    }

    private boolean hasNoOwner(OwnerContext context) {
        return context == null || context.getGlobalId() == null;
    }
}

