/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.collections.Lists;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.MapEnumeratorContext;

public class MapType
extends EnumerableType {
    private transient List<Class> elementTypes;

    public MapType(ContainerType containerType) {
        super(containerType.getBaseJavaType());
        this.elementTypes = new ArrayList<Class>();
        this.elementTypes.add(Integer.class);
        this.elementTypes.add(containerType.getItemClass());
    }

    public MapType(Type baseJavaType) {
        super(baseJavaType);
        this.elementTypes = this.getActualClassTypeArguments().size() == 2 ? Lists.immutableListOf(this.getActualClassTypeArguments().get(0), this.getActualClassTypeArguments().get(1)) : Collections.EMPTY_LIST;
    }

    @Override
    public boolean isFullyParametrized() {
        return this.elementTypes.size() == 2;
    }

    @Override
    public Map map(Object sourceMap_, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentIsNotNull(mapFunction);
        if (sourceMap_ == null) {
            return Collections.EMPTY_MAP;
        }
        Map sourceMap = (Map)sourceMap_;
        HashMap targetMap = new HashMap(sourceMap.size());
        MapEnumeratorContext enumeratorContext = new MapEnumeratorContext();
        owner.setEnumeratorContext(enumeratorContext);
        for (Map.Entry entry : sourceMap.entrySet()) {
            enumeratorContext.switchToKey();
            Object mappedKey = mapFunction.apply(entry.getKey(), owner);
            enumeratorContext.switchToValue(mappedKey);
            Object mappedValue = mapFunction.apply(entry.getValue(), owner);
            targetMap.put(mappedKey, mappedValue);
        }
        return Collections.unmodifiableMap(targetMap);
    }

    @Override
    public boolean isEmpty(Object map) {
        return map == null || ((Map)map).isEmpty();
    }

    @Override
    public List<Class> getElementTypes() {
        return this.elementTypes;
    }

    public Class getKeyClass() {
        if (this.isFullyParametrized()) {
            return this.elementTypes.get(0);
        }
        throw new JaversException(JaversExceptionCode.GENERIC_TYPE_NOT_PARAMETRIZED, this.getBaseJavaType().toString());
    }

    public Class getValueClass() {
        if (this.isFullyParametrized()) {
            return this.elementTypes.get(1);
        }
        throw new JaversException(JaversExceptionCode.GENERIC_TYPE_NOT_PARAMETRIZED, this.getBaseJavaType().toString());
    }
}

