/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.classes;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.classes.ClientsClassDefinition;
import org.javers.core.metamodel.classes.EntityDefinition;
import org.javers.core.metamodel.classes.ValueObjectDefinition;

public class ClassAnnotationsScanner {
    private final Set<String> entityAliases = Collections.unmodifiableSet(Sets.asSet("Entity", "MappedSuperclass"));
    private final Set<String> valueObjectAliases = Collections.unmodifiableSet(Sets.asSet("ValueObject", "Embeddable"));

    ClientsClassDefinition scanAndInfer(Class javaClass) {
        Validate.argumentIsNotNull(javaClass);
        for (Annotation ann : javaClass.getAnnotations()) {
            if (this.entityAliases.contains(ann.annotationType().getSimpleName())) {
                return new EntityDefinition(javaClass);
            }
            if (!this.valueObjectAliases.contains(ann.annotationType().getSimpleName())) continue;
            return new ValueObjectDefinition(javaClass);
        }
        return new ValueObjectDefinition(javaClass);
    }
}

