/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.util.List;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Entity;
import org.javers.core.metamodel.property.EntityDefinition;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.ManagedClassDefinition;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.PropertyScanner;
import org.javers.core.metamodel.property.ValueObject;
import org.javers.core.metamodel.property.ValueObjectDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedClassFactory {
    private static final Logger logger = LoggerFactory.getLogger(ManagedClassFactory.class);
    private final PropertyScanner propertyScanner;

    public ManagedClassFactory(PropertyScanner propertyScanner) {
        Validate.argumentIsNotNull(propertyScanner);
        this.propertyScanner = propertyScanner;
    }

    public <S> Entity createEntity(Class<S> clazz) {
        return this.create(new EntityDefinition(clazz));
    }

    public <S> ValueObject createValueObject(Class<S> clazz) {
        return this.create(new ValueObjectDefinition(clazz));
    }

    public ManagedClass infer(Class javaClass) {
        List<Property> properties = this.propertyScanner.scan(javaClass);
        Property foundIdProperty = this.findIdProperty(properties);
        if (foundIdProperty != null) {
            logger.debug("javersType type of {}(id:{}) inferred as Entity", (Object)javaClass.getSimpleName(), (Object)foundIdProperty.getName());
            return new Entity(javaClass, properties, foundIdProperty);
        }
        logger.debug("javersType of {} inferred as ValueObject", (Object)javaClass.getSimpleName());
        return new ValueObject(javaClass, properties);
    }

    private Property findIdProperty(List<Property> properties) {
        for (Property property : properties) {
            if (!property.looksLikeId()) continue;
            return property;
        }
        return null;
    }

    public ManagedClass create(ManagedClassDefinition managedClassDefinition) {
        if (managedClassDefinition instanceof ValueObjectDefinition) {
            return this.create((ValueObjectDefinition)managedClassDefinition);
        }
        if (managedClassDefinition instanceof EntityDefinition) {
            return this.create((EntityDefinition)managedClassDefinition);
        }
        throw new IllegalArgumentException("unsupported " + managedClassDefinition);
    }

    public Entity create(EntityDefinition entityDefinition) {
        List<Property> properties = this.propertyScanner.scan(entityDefinition.getClazz());
        Property idProperty = null;
        if (entityDefinition.hasCustomId()) {
            idProperty = this.findIdPropertyByName(properties, entityDefinition);
        }
        return new Entity(entityDefinition.getClazz(), properties, idProperty);
    }

    public ValueObject create(ValueObjectDefinition valueObjectDefinition) {
        List<Property> properties = this.propertyScanner.scan(valueObjectDefinition.getClazz());
        return new ValueObject(valueObjectDefinition.getClazz(), properties);
    }

    private Property findIdPropertyByName(List<Property> beanProperties, EntityDefinition entityDefinition) {
        for (Property property : beanProperties) {
            if (!property.getName().equals(entityDefinition.getIdPropertyName())) continue;
            return property;
        }
        throw new JaversException(JaversExceptionCode.PROPERTY_NOT_FOUND, entityDefinition.getIdPropertyName(), entityDefinition.getClazz().getName());
    }
}

