/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.HashMap;
import java.util.Map;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;

class NodeReuser {
    private final Map<Object, ObjectNode> reverseCdoIdMap = new HashMap<Object, ObjectNode>();
    private int reusedNodes;
    private int entities;
    private int valueObjects;

    NodeReuser() {
    }

    boolean isReusable(Cdo cdo) {
        return this.reverseCdoIdMap.containsKey(this.reverseCdoIdMapKey(cdo));
    }

    ObjectNode getForReuse(Cdo cdo) {
        ++this.reusedNodes;
        return this.reverseCdoIdMap.get(this.reverseCdoIdMapKey(cdo));
    }

    void saveForReuse(ObjectNode reference) {
        if (reference.getGlobalId() instanceof InstanceId) {
            ++this.entities;
        }
        if (reference.getGlobalId() instanceof ValueObjectId) {
            ++this.valueObjects;
        }
        this.reverseCdoIdMap.put(this.reverseCdoIdMapKey(reference.getCdo()), reference);
    }

    public int nodesCount() {
        return this.reverseCdoIdMap.size();
    }

    public int reusedNodesCount() {
        return this.reusedNodes;
    }

    public int entitiesCount() {
        return this.entities;
    }

    public int voCount() {
        return this.valueObjects;
    }

    private Object reverseCdoIdMapKey(Cdo cdo) {
        if (cdo.getGlobalId() instanceof InstanceId) {
            return cdo.getGlobalId();
        }
        return System.identityHashCode(cdo.getWrappedCdo().get());
    }
}

