/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import org.javers.core.graph.AbstractMapFunction;
import org.javers.core.graph.CdoFactory;
import org.javers.core.graph.MultiEdge;
import org.javers.core.graph.NodeReuser;
import org.javers.core.graph.ObjectGraphBuilder;
import org.javers.core.graph.ObjectNode;
import org.javers.core.graph.SingleEdge;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapEnumeratorContext;
import org.javers.core.metamodel.type.TypeMapper;

class EdgeBuilder {
    private final TypeMapper typeMapper;
    private final NodeReuser nodeReuser;
    private final CdoFactory cdoFactory;

    EdgeBuilder(TypeMapper typeMapper, NodeReuser nodeReuser, CdoFactory cdoFactory) {
        this.typeMapper = typeMapper;
        this.nodeReuser = nodeReuser;
        this.cdoFactory = cdoFactory;
    }

    String graphType() {
        return this.cdoFactory.typeDesc();
    }

    SingleEdge buildSingleEdge(ObjectNode node, Property singleRef) {
        Object rawReference = node.getPropertyValue(singleRef);
        Cdo cdo = this.asCdo(rawReference, this.createOwnerContext(node, singleRef));
        ObjectNode referencedNode = this.buildNodeStubOrReuse(cdo);
        return new SingleEdge(singleRef, referencedNode);
    }

    Cdo asCdo(Object target, OwnerContext owner) {
        return this.cdoFactory.create(target, owner);
    }

    private OwnerContext createOwnerContext(ObjectNode parentNode, Property property) {
        return new OwnerContext(parentNode.getGlobalId(), property.getName());
    }

    MultiEdge createMultiEdge(Property containerProperty, EnumerableType enumerableType, ObjectNode node, ObjectGraphBuilder objectGraphBuilder) {
        MultiEdge multiEdge = new MultiEdge(containerProperty);
        OwnerContext owner = this.createOwnerContext(node, containerProperty);
        MultiEdgeBuilderFunction edgeBuilder = new MultiEdgeBuilderFunction(multiEdge, enumerableType);
        Object container = node.getPropertyValue(containerProperty);
        enumerableType.map(container, edgeBuilder, owner);
        return multiEdge;
    }

    private ObjectNode buildNodeStubOrReuse(Cdo cdo) {
        if (this.nodeReuser.isReusable(cdo)) {
            return this.nodeReuser.getForReuse(cdo);
        }
        return this.buildNodeStub(cdo);
    }

    ObjectNode buildNodeStub(Cdo cdo) {
        return new ObjectNode(cdo);
    }

    private class MultiEdgeBuilderFunction
    extends AbstractMapFunction {
        final MultiEdge multiEdge;

        MultiEdgeBuilderFunction(MultiEdge multiEdge, EnumerableType enumerableType) {
            super(enumerableType, EdgeBuilder.this.typeMapper);
            this.multiEdge = multiEdge;
        }

        public Object apply(Object input, OwnerContext enumerationAwareOwnerContext) {
            if (!this.isManagedPosition(enumerationAwareOwnerContext)) {
                return input;
            }
            ObjectNode objectNode = EdgeBuilder.this.buildNodeStubOrReuse(EdgeBuilder.this.asCdo(input, enumerationAwareOwnerContext));
            this.multiEdge.addReferenceNode(objectNode);
            return null;
        }

        boolean isManagedPosition(OwnerContext enumerationAwareOwnerContext) {
            if (!this.isMap()) {
                return true;
            }
            MapEnumeratorContext mapContext = (MapEnumeratorContext)enumerationAwareOwnerContext.getEnumeratorContext();
            if (mapContext.isKey()) {
                return this.getKeyType() instanceof ManagedType;
            }
            return this.getValueType() instanceof ManagedType;
        }
    }
}

