/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.util.Collections;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.joda.time.LocalDateTime;

public final class Commit {
    private final CommitMetadata commitMetadata;
    private final List<CdoSnapshot> snapshots;
    private final Diff diff;

    Commit(CommitMetadata commitMetadata, List<CdoSnapshot> snapshots, Diff diff) {
        Validate.argumentsAreNotNull(commitMetadata, snapshots, diff);
        this.commitMetadata = commitMetadata;
        this.snapshots = snapshots;
        this.diff = diff;
    }

    public CommitId getId() {
        return this.commitMetadata.getId();
    }

    public String getAuthor() {
        return this.commitMetadata.getAuthor();
    }

    Diff getDiff() {
        return this.diff;
    }

    public LocalDateTime getCommitDate() {
        return this.commitMetadata.getCommitDate();
    }

    public List<CdoSnapshot> getSnapshots() {
        return Collections.unmodifiableList(this.snapshots);
    }

    public List<Change> getChanges() {
        return this.diff.getChanges();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Commit(id:" + this.commitMetadata.getId());
        b.append(", snapshots:" + this.snapshots.size());
        b.append(", " + this.diff.toString());
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit other = (Commit)o;
        return this.getId().equals(other.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

