/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.GlobalIdDTO;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.repository.api.JaversRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryRepository
implements JaversRepository {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryRepository.class);
    private Map<GlobalCdoId, LinkedList<CdoSnapshot>> snapshots = new HashMap<GlobalCdoId, LinkedList<CdoSnapshot>>();
    private CommitId head;
    private final GlobalIdFactory globalIdFactory;

    public InMemoryRepository(GlobalIdFactory globalIdFactory) {
        Validate.argumentIsNotNull(globalIdFactory);
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalCdoId globalId, int limit) {
        Validate.argumentIsNotNull(globalId);
        if (this.snapshots.containsKey(globalId)) {
            return Collections.unmodifiableList((List)this.snapshots.get(globalId));
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalCdoId globalId) {
        Validate.argumentsAreNotNull(globalId);
        if (this.snapshots.containsKey(globalId)) {
            List states = this.snapshots.get(globalId);
            return Optional.of(states.get(states.size() - 1));
        }
        return Optional.empty();
    }

    @Override
    public void persist(Commit commit) {
        Validate.argumentsAreNotNull(commit);
        List<CdoSnapshot> snapshots = commit.getSnapshots();
        for (CdoSnapshot s : snapshots) {
            this.persist(s);
        }
        logger.debug("{} snapshot(s) persisted", (Object)snapshots.size());
        this.head = commit.getId();
    }

    @Override
    public CommitId getHeadId() {
        return this.head;
    }

    @Override
    public void setJsonConverter(JsonConverter jsonConverter) {
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalIdDTO globalIdDTO, int limit) {
        Validate.argumentsAreNotNull(globalIdDTO);
        return this.getStateHistory(this.globalIdFactory.createFromDto(globalIdDTO), limit);
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalIdDTO globalIdDTO) {
        Validate.argumentsAreNotNull(globalIdDTO);
        return this.getLatest(this.globalIdFactory.createFromDto(globalIdDTO));
    }

    private void persist(CdoSnapshot snapshot) {
        LinkedList<CdoSnapshot> states = this.snapshots.get(snapshot.getGlobalId());
        if (states == null) {
            states = new LinkedList();
            this.snapshots.put(snapshot.getGlobalId(), states);
        }
        states.push(snapshot);
    }
}

