/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.HashMap;
import java.util.Map;
import org.javers.common.collections.Optional;
import org.javers.common.patterns.visitors.Visitable;
import org.javers.common.validation.Validate;
import org.javers.core.graph.Edge;
import org.javers.core.graph.GraphVisitor;
import org.javers.core.graph.SingleEdge;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.CdoWrapper;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.property.Entity;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.Property;

public class ObjectNode
implements Visitable<GraphVisitor> {
    private final Cdo cdo;
    private final Map<Property, Edge> edges = new HashMap<Property, Edge>();
    private boolean stub;

    public ObjectNode(Cdo cdo) {
        Validate.argumentIsNotNull(cdo);
        this.cdo = cdo;
        this.stub = true;
    }

    ObjectNode(Object cdo, Entity entity) {
        this(new CdoWrapper(cdo, InstanceId.createFromInstance(cdo, entity)));
    }

    public Optional<Object> wrappedCdo() {
        return this.cdo.getWrappedCdo();
    }

    public GlobalCdoId getGlobalCdoId() {
        return this.cdo.getGlobalId();
    }

    public GlobalCdoId getReference(Property property) {
        Edge edge = this.getEdge(property);
        if (edge != null && edge instanceof SingleEdge) {
            return ((SingleEdge)edge).getReference().getGlobalCdoId();
        }
        return (GlobalCdoId)this.getPropertyValue(property);
    }

    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        return this.cdo.getPropertyValue(property);
    }

    public boolean isNull(Property property) {
        Validate.argumentIsNotNull(property);
        return this.cdo.isNull(property);
    }

    Edge getEdge(Property property) {
        return this.edges.get(property);
    }

    int edgesCount() {
        return this.edges.size();
    }

    public ManagedClass getManagedClass() {
        return this.cdo.getManagedClass();
    }

    Cdo getCdo() {
        return this.cdo;
    }

    boolean isStub() {
        return this.stub;
    }

    void unstub() {
        this.stub = false;
    }

    void addEdge(Edge edge) {
        this.edges.put(edge.getProperty(), edge);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectNode that = (ObjectNode)o;
        return this.cdo.equals(that.cdo);
    }

    public int hashCode() {
        return this.cdo.hashCode();
    }

    @Override
    public void accept(GraphVisitor visitor) {
        if (visitor.wasVisited(this)) {
            return;
        }
        visitor.visit(this);
        for (Edge edge : this.edges.values()) {
            edge.accept(visitor);
        }
    }
}

