/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.Set;
import org.javers.common.collections.Collections;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetChangeAppender
extends PropertyChangeAppender<SetChange> {
    private static final Logger logger = LoggerFactory.getLogger(SetChangeAppender.class);
    private final TypeMapper typeMapper;

    public SetChangeAppender(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    protected boolean supports(JaversType propertyType) {
        return propertyType instanceof SetType;
    }

    public boolean isSupportedContainer(Property property) {
        ContainerType propertyType = (ContainerType)this.typeMapper.getPropertyType(property);
        if (!this.typeMapper.isPrimitiveOrValue(propertyType.getItemClass())) {
            logger.error(JaversExceptionCode.DIFF_NOT_IMPLEMENTED.getMessage() + " on " + property);
            return false;
        }
        return true;
    }

    @Override
    protected SetChange calculateChanges(NodePair pair, Property property) {
        Set leftValues = (Set)pair.getLeftPropertyValue(property);
        Set rightValues = (Set)pair.getRightPropertyValue(property);
        ArrayList<ContainerElementChange> changes = new ArrayList<ContainerElementChange>();
        for (Object addedValue : Collections.difference(rightValues, leftValues)) {
            changes.add(new ValueAdded(addedValue));
        }
        for (Object addedValue : Collections.difference(leftValues, rightValues)) {
            changes.add(new ValueRemoved(addedValue));
        }
        if (changes.isEmpty()) {
            return null;
        }
        if (!this.isSupportedContainer(property)) {
            return null;
        }
        return new SetChange(pair.getGlobalCdoId(), property, changes);
    }
}

