/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.validation.Validate;
import org.javers.core.diff.GraphPair;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.RealNodePair;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.GlobalCdoId;

public class NodeMatcher {
    public List<NodePair> match(GraphPair graphPair) {
        Validate.argumentIsNotNull(graphPair);
        ArrayList<NodePair> pairs = new ArrayList<NodePair>();
        Map<GlobalCdoId, ObjectNode> rightMap = this.asMap(graphPair.getRightNodeSet());
        for (ObjectNode left : graphPair.getLeftNodeSet()) {
            GlobalCdoId key = left.getGlobalCdoId();
            if (!rightMap.containsKey(key)) continue;
            pairs.add(new RealNodePair(left, rightMap.get(key)));
        }
        return pairs;
    }

    private Map<GlobalCdoId, ObjectNode> asMap(Set<ObjectNode> nodes) {
        HashMap<GlobalCdoId, ObjectNode> map = new HashMap<GlobalCdoId, ObjectNode>();
        for (ObjectNode node : nodes) {
            map.put(node.getGlobalCdoId(), node);
        }
        return map;
    }
}

