/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.repository.api.JaversRepository;

public class JaversExtendedRepository
implements JaversRepository {
    private final JaversRepository delegate;
    private final GlobalIdFactory globalIdFactory;

    public JaversExtendedRepository(JaversRepository delegate, GlobalIdFactory globalIdFactory) {
        this.delegate = delegate;
        this.globalIdFactory = globalIdFactory;
    }

    public List<CdoSnapshot> getStateHistory(Object localId, Class entityClass, int limit) {
        Validate.argumentsAreNotNull(localId, entityClass);
        InstanceId instanceId = this.globalIdFactory.createFromId(localId, entityClass);
        return this.delegate.getStateHistory(instanceId, limit);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalCdoId globalId, int limit) {
        return this.delegate.getStateHistory(globalId, limit);
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalCdoId globalId) {
        return this.delegate.getLatest(globalId);
    }

    @Override
    public void persist(Commit commit) {
        this.delegate.persist(commit);
    }

    @Override
    public CommitId getHeadId() {
        return this.delegate.getHeadId();
    }
}

