/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import org.javers.common.collections.Defaults;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.collections.Objects;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.core.graph.AbstractMapFunction;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapEnumeratorContext;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;

public class SnapshotFactory {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    public SnapshotFactory(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    public CdoSnapshot create(Object liveCdo, GlobalCdoId id) {
        CdoSnapshotBuilder snapshot = CdoSnapshotBuilder.cdoSnapshot(id);
        for (Property property : id.getCdoClass().getProperties()) {
            Object propertyVal = property.get(liveCdo);
            if (Objects.nullSafeEquals(propertyVal, Defaults.defaultValue(property.getType()))) continue;
            Object propertyType = this.typeMapper.getPropertyType(property);
            OwnerContext owner = new OwnerContext(id, property.getName());
            Object filteredPropertyVal = propertyType instanceof EnumerableType ? this.extractAndDehydrateEnumerable(propertyVal, (EnumerableType)propertyType, owner) : this.dehydrate(propertyVal, (JaversType)propertyType, owner);
            snapshot.withPropertyValue(property, filteredPropertyVal);
        }
        return snapshot.build();
    }

    public CdoSnapshot create(ObjectNode objectNode) {
        return this.create(objectNode.wrappedCdo().get(), objectNode.getGlobalCdoId());
    }

    private Object extractAndDehydrateEnumerable(Object propertyVal, EnumerableType propertyType, OwnerContext owner) {
        EnumerableFunction dehydratorMapFunction;
        if (!propertyType.isFullyParametrized()) {
            throw new JaversException(JaversExceptionCode.GENERIC_TYPE_NOT_PARAMETRIZED, propertyType.getBaseJavaType().toString());
        }
        if (propertyType instanceof ContainerType) {
            dehydratorMapFunction = new DehydrateContainerFunction((ContainerType)propertyType);
        } else if (propertyType instanceof MapType) {
            dehydratorMapFunction = new DehydrateMapFunction((MapType)propertyType, this.typeMapper);
        } else {
            throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
        }
        return propertyType.map(propertyVal, dehydratorMapFunction, owner);
    }

    private Object dehydrate(Object item, JaversType targetType, OwnerContext context) {
        if (targetType instanceof ManagedType) {
            return this.globalIdFactory.createId(item, context);
        }
        return item;
    }

    private class DehydrateMapFunction
    extends AbstractMapFunction {
        DehydrateMapFunction(MapType mapType, TypeMapper typeMapper) {
            super(mapType, typeMapper);
        }

        public Object apply(Object input, OwnerContext enumerationAwareOwnerContext) {
            MapEnumeratorContext mapContext = (MapEnumeratorContext)enumerationAwareOwnerContext.getEnumeratorContext();
            if (mapContext.isKey()) {
                return SnapshotFactory.this.dehydrate(input, this.getKeyType(), enumerationAwareOwnerContext);
            }
            return SnapshotFactory.this.dehydrate(input, this.getValueType(), enumerationAwareOwnerContext);
        }
    }

    private class DehydrateContainerFunction
    implements EnumerableFunction {
        JaversType itemType;

        DehydrateContainerFunction(ContainerType containerType) {
            this.itemType = SnapshotFactory.this.typeMapper.getJaversType(containerType.getItemClass());
        }

        public Object apply(Object input, OwnerContext enumerationAwareOwnerContext) {
            return SnapshotFactory.this.dehydrate(input, this.itemType, enumerationAwareOwnerContext);
        }
    }
}

