/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.snapshot.SnapshotFactory;
import org.javers.repository.api.JaversExtendedRepository;

public class GraphSnapshotFactory {
    private final SnapshotFactory snapshotFactory;
    private final JaversExtendedRepository javersRepository;

    public GraphSnapshotFactory(SnapshotFactory snapshotFactory, JaversExtendedRepository javersRepository) {
        this.snapshotFactory = snapshotFactory;
        this.javersRepository = javersRepository;
    }

    public List<CdoSnapshot> create(LiveGraph currentVersion) {
        Validate.argumentIsNotNull(currentVersion);
        return this.doSnapshotsAndReuse(currentVersion.flatten());
    }

    private List<CdoSnapshot> doSnapshotsAndReuse(Set<ObjectNode> currentVersion) {
        ArrayList<CdoSnapshot> reused = new ArrayList<CdoSnapshot>();
        for (ObjectNode node : currentVersion) {
            CdoSnapshot fresh = this.snapshotFactory.create(node);
            Optional<CdoSnapshot> existing = this.javersRepository.getLatest(fresh.getGlobalId());
            if (existing.isEmpty()) {
                reused.add(fresh);
                continue;
            }
            if (existing.get().stateEquals(fresh)) continue;
            reused.add(fresh);
        }
        return reused;
    }
}

