/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.pico;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.javers.common.pico.JaversModule;
import org.javers.common.validation.Validate;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.MappingStyle;
import org.javers.core.metamodel.property.BeanBasedPropertyScanner;
import org.javers.core.metamodel.property.FieldBasedPropertyScanner;
import org.javers.core.metamodel.property.ManagedClassFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedClassFactoryModule
implements JaversModule {
    private static final Logger logger = LoggerFactory.getLogger(ManagedClassFactoryModule.class);
    private static final Class[] moduleComponents = new Class[]{ManagedClassFactory.class};
    private static final Map<MappingStyle, Class> propertyScannersMapping = new HashMap(){
        {
            this.put(MappingStyle.BEAN, BeanBasedPropertyScanner.class);
            this.put(MappingStyle.FIELD, FieldBasedPropertyScanner.class);
        }
    };
    private final JaversCoreConfiguration javersConfiguration;

    public ManagedClassFactoryModule(JaversCoreConfiguration javersConfiguration) {
        this.javersConfiguration = javersConfiguration;
    }

    @Override
    public Collection<Class> getModuleComponents() {
        ArrayList<Class> components = new ArrayList<Class>();
        Collections.addAll(components, moduleComponents);
        this.addPropertyScanner(components);
        return components;
    }

    private void addPropertyScanner(Collection<Class> components) {
        MappingStyle mappingStyle = this.javersConfiguration.getMappingStyle();
        logger.info("using " + mappingStyle.name() + " mappingStyle");
        Validate.conditionFulfilled(propertyScannersMapping.containsKey((Object)mappingStyle), "No PropertyScanner defined for " + (Object)((Object)mappingStyle));
        components.add(propertyScannersMapping.get((Object)mappingStyle));
    }
}

