/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.persistence.Id;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Property;

public class FieldProperty
implements Property {
    private final transient Field field;

    public FieldProperty(Field field) {
        Validate.argumentIsNotNull(field, "field should not be null!");
        this.field = field;
    }

    @Override
    public Type getGenericType() {
        return this.field.getGenericType();
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public boolean looksLikeId() {
        return this.field.isAnnotationPresent(Id.class);
    }

    @Override
    public Object get(Object target) {
        return ReflectionUtil.invokeFieldEvenIfPrivate(this.field, target);
    }

    @Override
    public boolean isNull(Object target) {
        return this.get(target) == null;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldProperty that = (FieldProperty)o;
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String toString() {
        return this.field.getDeclaringClass().getSimpleName() + "." + this.field.getName();
    }
}

