/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.property.ValueObject;

public class ValueObjectId
extends UnboundedValueObjectId {
    private final GlobalCdoId ownerId;
    private final String fragment;

    public ValueObjectId(ValueObject valueObject, GlobalCdoId ownerId, String fragment) {
        super(valueObject);
        Validate.argumentsAreNotNull(ownerId, fragment);
        this.ownerId = ownerId;
        this.fragment = fragment;
    }

    public ValueObjectId(ValueObject valueObject, OwnerContext ownerContext) {
        this(valueObject, ownerContext.getGlobalCdoId(), ownerContext.getPath());
    }

    public String getFragment() {
        return this.fragment;
    }

    @Override
    public Object getCdoId() {
        return null;
    }

    public GlobalCdoId getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String value() {
        return this.getOwnerId().value() + "#" + this.fragment;
    }

    public static class ValueObjectIdDTO
    extends GlobalCdoId.GlobalCdoIdDTO {
        private InstanceId.InstanceIdDTO ownerId;
        private final String fragment;

        private ValueObjectIdDTO(Class ownerClass, Object ownerLocalId, String fragment) {
            this.ownerId = InstanceId.InstanceIdDTO.instanceId(ownerLocalId, ownerClass);
            this.fragment = fragment;
        }

        public static ValueObjectIdDTO valueObjectId(Object ownerLocalId, Class ownerClass, String fragment) {
            return new ValueObjectIdDTO(ownerClass, ownerLocalId, fragment);
        }

        @Override
        public String value() {
            return this.ownerId.value() + "#" + this.fragment;
        }
    }
}

