/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.property.Entity;

public class InstanceId
extends GlobalCdoId {
    private final transient Entity entity;
    private final Object cdoId;

    private InstanceId(Object cdoId, Entity entity) {
        Validate.argumentsAreNotNull(cdoId, entity);
        this.entity = entity;
        this.cdoId = cdoId;
    }

    public static InstanceId createFromInstance(Object instance, Entity entity) {
        return new InstanceId(entity.getIdOf(instance), entity);
    }

    public static InstanceId createFromId(Object id, Entity entity) {
        return new InstanceId(id, entity);
    }

    @Override
    public Entity getCdoClass() {
        return this.entity;
    }

    @Override
    public Object getCdoId() {
        return this.cdoId;
    }

    @Override
    public String value() {
        return this.entity.getSourceClass().getName() + "/" + this.cdoId;
    }

    public boolean idEquals(Object instance) {
        if (instance == null) {
            return false;
        }
        if (!this.entity.getSourceClass().isAssignableFrom(instance.getClass())) {
            return false;
        }
        return this.cdoId.equals(this.entity.getIdOf(instance));
    }

    public static class InstanceIdDTO
    extends GlobalCdoId.GlobalCdoIdDTO {
        private final Class javaClass;
        private final Object localId;

        private InstanceIdDTO(Class javaClass, Object localId) {
            this.javaClass = javaClass;
            this.localId = localId;
        }

        public static InstanceIdDTO instanceId(Object localId, Class javaClass) {
            return new InstanceIdDTO(javaClass, localId);
        }

        @Override
        public String value() {
            return this.javaClass.getName() + "/" + this.localId;
        }
    }
}

