/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.property.Entity;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.ValueObject;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;

public class GlobalIdFactory {
    private final TypeMapper typeMapper;

    public GlobalIdFactory(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public GlobalCdoId createId(Object targetCdo) {
        return this.createId(targetCdo, null);
    }

    public GlobalCdoId createId(Object targetCdo, OwnerContext owner) {
        Validate.argumentsAreNotNull(targetCdo);
        ManagedClass targetManagedClass = this.getManagedClassOf(targetCdo);
        if (targetManagedClass instanceof Entity) {
            return InstanceId.createFromInstance(targetCdo, (Entity)targetManagedClass);
        }
        if (targetManagedClass instanceof ValueObject && this.hasNoOwner(owner)) {
            return new UnboundedValueObjectId((ValueObject)targetManagedClass);
        }
        if (targetManagedClass instanceof ValueObject && this.hasOwner(owner)) {
            return new ValueObjectId((ValueObject)targetManagedClass, owner);
        }
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
    }

    public ValueObjectId createFromPath(InstanceId owner, Class valueObjectClass, String path) {
        ManagedClass targetManagedClass = this.getManagedClass(valueObjectClass);
        return new ValueObjectId((ValueObject)targetManagedClass, owner, path);
    }

    public InstanceId createFromId(Object localId, Class entityClass) {
        ManagedClass managedClass = this.getManagedClass(entityClass);
        if (!(managedClass instanceof Entity)) {
            throw new JaversException(JaversExceptionCode.ENTITY_NOT_MAPPED, entityClass, managedClass.getClass().getSimpleName());
        }
        return InstanceId.createFromId(localId, (Entity)managedClass);
    }

    private ManagedClass getManagedClassOf(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.getManagedClass(cdo.getClass());
    }

    public ManagedClass getManagedClass(Class javaClass) {
        JaversType jType = this.typeMapper.getJaversType(javaClass);
        if (jType instanceof ManagedType) {
            return ((ManagedType)jType).getManagedClass();
        }
        throw new JaversException(JaversExceptionCode.CLASS_NOT_MANAGED, javaClass, jType.getClass().getSimpleName());
    }

    private boolean hasOwner(OwnerContext context) {
        return context != null && context.getGlobalCdoId() != null;
    }

    private boolean hasNoOwner(OwnerContext context) {
        return context == null || context.getGlobalCdoId() == null;
    }
}

