/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.List;
import org.javers.common.collections.Predicate;
import org.javers.common.validation.Validate;
import org.javers.core.graph.CdoFactory;
import org.javers.core.graph.EdgeBuilder;
import org.javers.core.graph.MultiEdge;
import org.javers.core.graph.NodeReuser;
import org.javers.core.graph.ObjectNode;
import org.javers.core.graph.SingleEdge;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectGraphBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ObjectGraphBuilder.class);
    private final TypeMapper typeMapper;
    private boolean built;
    private final EdgeBuilder edgeBuilder;
    private final NodeReuser nodeReuser = new NodeReuser();

    public ObjectGraphBuilder(TypeMapper typeMapper, CdoFactory cdoFactory) {
        Validate.argumentsAreNotNull(typeMapper, cdoFactory);
        this.typeMapper = typeMapper;
        this.edgeBuilder = new EdgeBuilder(typeMapper, this.nodeReuser, cdoFactory);
    }

    public ObjectNode buildGraph(Object handle) {
        Cdo cdo = this.edgeBuilder.asCdo(handle, null);
        ObjectNode root = this.buildNode(cdo);
        logger.info("{} graph assembled, object nodes: {}, entities: {}, valueObjects: {}", new Object[]{this.edgeBuilder.graphType(), this.nodeReuser.nodesCount(), this.nodeReuser.entitiesCount(), this.nodeReuser.voCount()});
        this.switchToBuilt();
        return root;
    }

    private ObjectNode buildNode(Cdo cdo) {
        Validate.argumentIsNotNull(cdo);
        ObjectNode node = this.edgeBuilder.buildNodeStub(cdo);
        this.continueIfStub(node);
        return node;
    }

    private void switchToBuilt() {
        if (this.built) {
            throw new IllegalStateException("ObjectGraphBuilder is stateful builder (not a Service)");
        }
        this.built = true;
    }

    private void buildEdges(ObjectNode node) {
        this.buildSingleEdges(node);
        this.buildMultiEdges(node);
    }

    private void continueIfStub(ObjectNode referencedNode) {
        if (referencedNode.isStub()) {
            this.nodeReuser.saveForReuse(referencedNode);
            referencedNode.unstub();
            this.buildEdges(referencedNode);
        }
    }

    private void buildSingleEdges(ObjectNode node) {
        for (Property singleRef : this.getSingleReferences(node.getManagedClass())) {
            if (node.isNull(singleRef)) continue;
            SingleEdge edge = this.edgeBuilder.buildSingleEdge(node, singleRef);
            this.continueIfStub(edge.getReference());
            node.addEdge(edge);
        }
    }

    private void buildMultiEdges(ObjectNode node) {
        for (Property containerProperty : this.getNonEmptyEnumerablesWithManagedClasses(node)) {
            EnumerableType enumerableType = (EnumerableType)this.typeMapper.getPropertyType(containerProperty);
            MultiEdge multiEdge = this.edgeBuilder.createMultiEdge(containerProperty, enumerableType, node, this);
            for (ObjectNode referencedNode : multiEdge.getReferences()) {
                this.continueIfStub(referencedNode);
            }
            node.addEdge(multiEdge);
        }
    }

    private List<Property> getSingleReferences(ManagedClass managedClass) {
        return managedClass.getProperties(new Predicate<Property>(){

            @Override
            public boolean apply(Property property) {
                return ObjectGraphBuilder.this.typeMapper.isEntityReferenceOrValueObject(property);
            }
        });
    }

    private List<Property> getNonEmptyEnumerablesWithManagedClasses(final ObjectNode node) {
        return node.getManagedClass().getProperties(new Predicate<Property>(){

            @Override
            public boolean apply(Property property) {
                Object javersType = ObjectGraphBuilder.this.typeMapper.getPropertyType(property);
                if (!(javersType instanceof EnumerableType)) {
                    return false;
                }
                EnumerableType enumerableType = (EnumerableType)javersType;
                Object container = node.getPropertyValue(property);
                if (enumerableType.isEmpty(container)) {
                    return false;
                }
                if (node.isNull(property)) {
                    return false;
                }
                return ObjectGraphBuilder.this.typeMapper.isContainerOfManagedClasses(enumerableType) || ObjectGraphBuilder.this.typeMapper.isMapWithManagedClass(enumerableType);
            }
        });
    }
}

