/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import java.util.Map;
import org.javers.common.collections.Arrays;
import org.javers.common.collections.Lists;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.MapChangeAppender;
import org.javers.core.diff.appenders.MapChangesToListChangesFunction;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.ArrayChange;
import org.javers.core.diff.changetype.ContainerValueChange;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayChangeAppender
extends PropertyChangeAppender<ArrayChange> {
    private static final Logger logger = LoggerFactory.getLogger(ArrayChangeAppender.class);
    private final MapChangeAppender mapChangeAppender;
    private final TypeMapper typeMapper;

    public ArrayChangeAppender(MapChangeAppender mapChangeAppender, TypeMapper typeMapper) {
        this.mapChangeAppender = mapChangeAppender;
        this.typeMapper = typeMapper;
    }

    @Override
    protected Class<? extends JaversType> getSupportedPropertyType() {
        return ArrayType.class;
    }

    public boolean isSupportedContainer(Property property) {
        ContainerType propertyType = (ContainerType)this.typeMapper.getPropertyType(property);
        if (!this.typeMapper.isPrimitiveOrValueOrObject(propertyType.getItemClass())) {
            logger.error(JaversExceptionCode.DIFF_NOT_IMPLEMENTED.getMessage() + " on " + property);
            return false;
        }
        return true;
    }

    @Override
    protected ArrayChange calculateChanges(NodePair pair, Property property) {
        Map rightMap;
        Map leftMap = Arrays.asMap(pair.getLeftPropertyValue(property));
        List<EntryChange> entryChanges = this.mapChangeAppender.calculateEntryChanges(leftMap, rightMap = Arrays.asMap(pair.getRightPropertyValue(property)));
        if (!entryChanges.isEmpty()) {
            if (!this.isSupportedContainer(property)) {
                return null;
            }
            List<ContainerValueChange> elementChanges = Lists.transform(entryChanges, new MapChangesToListChangesFunction());
            return new ArrayChange(pair.getGlobalCdoId(), property, elementChanges);
        }
        return null;
    }
}

