/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.GraphFactory;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffBuilder;
import org.javers.core.diff.FakeNodePair;
import org.javers.core.diff.GraphPair;
import org.javers.core.diff.NodeMatcher;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.ObjectGraph;
import org.javers.core.diff.appenders.NodeChangeAppender;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;

public class DiffFactory {
    private final NodeMatcher nodeMatcher = new NodeMatcher();
    private final TypeMapper typeMapper;
    private final List<NodeChangeAppender> nodeChangeAppenders;
    private final List<PropertyChangeAppender> propertyChangeAppender;
    private final GraphFactory graphFactory;

    public DiffFactory(TypeMapper typeMapper, List<NodeChangeAppender> nodeChangeAppenders, List<PropertyChangeAppender> propertyChangeAppender, GraphFactory graphFactory) {
        this.typeMapper = typeMapper;
        this.nodeChangeAppenders = nodeChangeAppenders;
        this.propertyChangeAppender = propertyChangeAppender;
        this.graphFactory = graphFactory;
    }

    public Diff initial(Object newDomainObject) {
        return this.createInitial(this.buildGraph(newDomainObject));
    }

    public Diff compare(Object oldVersion, Object currentVersion) {
        return this.create(this.buildGraph(oldVersion), this.buildGraph(currentVersion));
    }

    public Diff create(ObjectGraph leftGraph, ObjectGraph rightGraph) {
        Validate.argumentsAreNotNull(leftGraph, rightGraph);
        GraphPair graphPair = new GraphPair(leftGraph, rightGraph);
        return this.createAndAppendChanges(graphPair);
    }

    public Diff createInitial(ObjectGraph currentGraph) {
        Validate.argumentIsNotNull(currentGraph);
        GraphPair graphPair = new GraphPair(currentGraph);
        return this.createAndAppendChanges(graphPair);
    }

    private LiveGraph buildGraph(Object handle) {
        return this.graphFactory.createLiveGraph(handle);
    }

    private Diff createAndAppendChanges(GraphPair graphPair) {
        DiffBuilder diff = DiffBuilder.diff();
        for (NodeChangeAppender appender : this.nodeChangeAppenders) {
            diff.addChanges(appender.getChangeSet(graphPair));
        }
        for (ObjectNode node : graphPair.getOnlyOnRight()) {
            FakeNodePair pair = new FakeNodePair(node);
            this.appendPropertyChanges(diff, pair);
        }
        for (NodePair pair : this.nodeMatcher.match(graphPair)) {
            this.appendPropertyChanges(diff, pair);
        }
        return diff.build();
    }

    private void appendPropertyChanges(DiffBuilder diff, NodePair pair) {
        List<Property> nodeProperties = pair.getProperties();
        for (Property property : nodeProperties) {
            if (pair.isNullOnBothSides(property)) continue;
            Object javersType = this.typeMapper.getPropertyType(property);
            for (PropertyChangeAppender appender : this.propertyChangeAppender) {
                Object change = appender.calculateChangesIfSupported(pair, property, (JaversType)javersType);
                if (change == null) continue;
                diff.addChange((Change)change, pair.getRight().wrappedCdo());
            }
        }
    }
}

