/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import org.javers.common.collections.Optional;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.patterns.visitors.Visitable;
import org.javers.common.validation.Validate;
import org.javers.core.diff.ChangeVisitor;
import org.javers.core.metamodel.object.GlobalCdoId;

public abstract class Change
implements Visitable<ChangeVisitor> {
    private final GlobalCdoId globalCdoId;
    private transient Optional<Object> affectedCdo;

    protected Change(GlobalCdoId globalCdoId) {
        Validate.argumentIsNotNull(globalCdoId);
        this.globalCdoId = globalCdoId;
    }

    public GlobalCdoId getGlobalCdoId() {
        return this.globalCdoId;
    }

    public Object getAffectedCdo() {
        if (this.affectedCdo == null || this.affectedCdo.isEmpty()) {
            throw new JaversException(JaversExceptionCode.AFFECTED_CDO_IS_NOT_AVAILABLE, new Object[0]);
        }
        return this.affectedCdo.get();
    }

    protected void setAffectedCdo(Optional<Object> affectedCdo) {
        Validate.argumentIsNotNull(affectedCdo);
        Validate.conditionFulfilled(this.affectedCdo == null, "affectedCdo already set");
        this.affectedCdo = affectedCdo;
    }

    @Override
    public void accept(ChangeVisitor changeVisitor) {
        changeVisitor.visit(this);
    }
}

