/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import org.javers.common.validation.Validate;

public class Optional<T> {
    private static Optional EMPTY = new Optional();
    private T reference;

    private Optional() {
    }

    private Optional(T reference) {
        Validate.argumentIsNotNull(reference);
        this.reference = reference;
    }

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public static <T> Optional<T> of(T reference) {
        return new Optional<T>(reference);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public T get() {
        if (this.isEmpty()) {
            throw new IllegalStateException("can't get() from empty optional");
        }
        return this.reference;
    }
}

