/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.object.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Predicate;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.property.Entity;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.property.ValueObject;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.model.object.graph.MultiEdge;
import org.javers.model.object.graph.ObjectNode;
import org.javers.model.object.graph.ObjectWrapper;
import org.javers.model.object.graph.SingleEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectGraphBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ObjectGraphBuilder.class);
    private final TypeMapper typeMapper;
    private boolean built;
    private final Map<Cdo, ObjectWrapper> reverseCdoIdMap = new HashMap<Cdo, ObjectWrapper>();

    public ObjectGraphBuilder(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public ObjectNode buildGraph(Object cdo) {
        ObjectNode root = this.buildNode(this.asCdo(cdo, null));
        logger.debug("done building objectGraph for root [" + root + "], nodes: " + this.reverseCdoIdMap.size());
        this.switchToBuilt();
        return root;
    }

    private ObjectNode buildNode(Cdo cdo) {
        Validate.argumentIsNotNull(cdo);
        ObjectWrapper node = this.buildNodeStubAndSaveForReuse(cdo);
        this.buildEdges(node);
        return node;
    }

    private void switchToBuilt() {
        if (this.built) {
            throw new IllegalStateException("ObjectGraphBuilder is stateful builder (not a Service)");
        }
        this.built = true;
    }

    private void buildEdges(ObjectWrapper node) {
        this.buildSingleEdges(node);
        this.buildMultiEdges(node);
    }

    private void buildSingleEdges(ObjectWrapper node) {
        for (Property singleRef : this.getSingleReferences(node.getManagedClass())) {
            if (singleRef.isNull(node.unwrapCdo())) continue;
            Object referencedRawCdo = singleRef.get(node.unwrapCdo());
            ObjectNode referencedNode = this.buildNodeOrReuse(this.asCdo(referencedRawCdo, new OwnerContext(node, singleRef.getName())));
            SingleEdge edge = new SingleEdge(singleRef, referencedNode);
            node.addEdge(edge);
        }
    }

    private List<Property> getSingleReferences(ManagedClass managedClass) {
        return managedClass.getProperties(new Predicate<Property>(){

            @Override
            public boolean apply(Property property) {
                return ObjectGraphBuilder.this.typeMapper.isEntityReferenceOrValueObject(property);
            }
        });
    }

    private List<Property> getCollectionsOfEntityReferences(ManagedClass managedClass) {
        return managedClass.getProperties(new Predicate<Property>(){

            @Override
            public boolean apply(Property property) {
                return ObjectGraphBuilder.this.typeMapper.isCollectionOfEntityReferences(property);
            }
        });
    }

    private void buildMultiEdges(ObjectWrapper node) {
        for (Property colProperty : this.getCollectionsOfEntityReferences(node.getManagedClass())) {
            Collection collectionOfReferences;
            if (colProperty.isNull(node.unwrapCdo()) || (collectionOfReferences = (Collection)colProperty.get(node.unwrapCdo())).isEmpty()) continue;
            MultiEdge multiEdge = this.createMultiEdge(colProperty, collectionOfReferences, new OwnerContext(node, colProperty.getName()));
            node.addEdge(multiEdge);
        }
    }

    private MultiEdge createMultiEdge(Property multiRef, Collection collectionOfReferences, OwnerContext owner) {
        MultiEdge multiEdge = new MultiEdge(multiRef);
        for (Object referencedRawCdo : collectionOfReferences) {
            ObjectNode objectNode = this.buildNodeOrReuse(this.asCdo(referencedRawCdo, owner));
            multiEdge.addReferenceNode(objectNode);
        }
        return multiEdge;
    }

    private ObjectWrapper buildNodeStubAndSaveForReuse(Cdo cdo) {
        ObjectWrapper nodeStub = new ObjectWrapper(cdo);
        this.reverseCdoIdMap.put(cdo, nodeStub);
        return nodeStub;
    }

    private ObjectNode buildNodeOrReuse(Cdo referencedCdo) {
        if (this.reverseCdoIdMap.containsKey(referencedCdo)) {
            return this.reverseCdoIdMap.get(referencedCdo);
        }
        return this.buildNode(referencedCdo);
    }

    private Cdo asCdo(Object targetCdo, OwnerContext owner) {
        ManagedClass targetManagedClass = this.getManagedCLass(targetCdo);
        if (targetManagedClass instanceof Entity) {
            Entity entity = (Entity)targetManagedClass;
            return new Cdo(targetCdo, new InstanceId(targetCdo, entity));
        }
        if (targetManagedClass instanceof ValueObject && owner != null) {
            ValueObject valueObject = (ValueObject)targetManagedClass;
            return new Cdo(targetCdo, new ValueObjectId(valueObject, owner.getGlobalCdoId(), owner.path));
        }
        if (targetManagedClass instanceof ValueObject && owner == null) {
            ValueObject valueObject = (ValueObject)targetManagedClass;
            return new Cdo(targetCdo, new UnboundedValueObjectId(valueObject));
        }
        throw new IllegalStateException("not implemented");
    }

    private ManagedClass getManagedCLass(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.typeMapper.getManagedClass(cdo.getClass());
    }

    private class OwnerContext {
        final ObjectWrapper owner;
        final String path;

        OwnerContext(ObjectWrapper owner, String path) {
            this.owner = owner;
            this.path = path;
        }

        GlobalCdoId getGlobalCdoId() {
            return this.owner.getGlobalCdoId();
        }
    }
}

