/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.collections.Primitives;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.ManagedClassDefinition;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.DistancePair;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeFactory;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper {
    private static final Logger logger = LoggerFactory.getLogger(TypeMapper.class);
    private final TypeFactory typeFactory;
    private final Map<Type, JaversType> mappedTypes;

    public TypeMapper(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.mappedTypes = new HashMap<Type, JaversType>();
        for (Class<?> primitiveOrBox : Primitives.getPrimitiveAndBoxTypes()) {
            this.registerPrimitiveType(primitiveOrBox);
        }
        this.registerPrimitiveType(String.class);
        this.registerPrimitiveType(Enum.class);
        this.addType(new ArrayType((Type)((Object)Object[].class)));
        this.registerValueType(LocalDateTime.class);
        this.registerValueType(BigDecimal.class);
        this.registerValueType(Date.class);
        this.addType(new SetType((Type)((Object)Set.class)));
        this.addType(new ListType((Type)((Object)List.class)));
        this.addType(new MapType((Type)((Object)Map.class)));
    }

    public JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        JaversType jType = this.getExactMatchingJaversType(javaType);
        if (jType != null) {
            return jType;
        }
        return this.createMapping(javaType);
    }

    public ManagedClass getManagedClass(Class javaClass) {
        JaversType jType = this.getJaversType(javaClass);
        if (jType instanceof ManagedType) {
            return ((ManagedType)jType).getManagedClass();
        }
        throw new IllegalArgumentException("getManagedClass(" + javaClass.getSimpleName() + ") " + "given javaClass is mapped to " + jType.getClass().getSimpleName() + ", ManagedType expected");
    }

    public JaversType getPropertyType(Property property) {
        return this.getJaversType(property.getGenericType());
    }

    public boolean isEntityReferenceOrValueObject(Property property) {
        JaversType javersType = this.getPropertyType(property);
        return javersType instanceof EntityType || javersType instanceof ValueObjectType;
    }

    public boolean isSupportedMap(MapType propertyType) {
        if (propertyType.getEntryClass() == null) {
            return false;
        }
        return this.isPrimitiveOrValueOrObject(propertyType.getEntryClass().getKey()) && this.isPrimitiveOrValueOrObject(propertyType.getEntryClass().getValue());
    }

    public boolean isCollectionOfEntityReferences(Property property) {
        JaversType javersType = this.getPropertyType(property);
        if (!(javersType instanceof CollectionType)) {
            return false;
        }
        CollectionType collectionType = (CollectionType)javersType;
        if (collectionType.getElementType() == null) {
            return false;
        }
        JaversType elementType = this.getJaversType(collectionType.getElementType());
        return elementType instanceof EntityType;
    }

    private void registerPrimitiveType(Class<?> primitiveClass) {
        this.addType(new PrimitiveType(primitiveClass));
    }

    public void registerManagedClass(ManagedClassDefinition def) {
        this.addType(this.typeFactory.createFromDefinition(def));
    }

    public void registerValueType(Class<?> objectValue) {
        this.addType(new ValueType(objectValue));
    }

    public boolean isSupportedContainer(ContainerType propertyType) {
        return this.isPrimitiveOrValueOrObject(propertyType.getElementType());
    }

    protected <T extends JaversType> List<T> getMappedTypes(Class<T> ofType) {
        ArrayList<JaversType> result = new ArrayList<JaversType>();
        for (JaversType jType : this.mappedTypes.values()) {
            if (!ofType.isAssignableFrom(jType.getClass())) continue;
            result.add(jType);
        }
        return result;
    }

    private boolean isPrimitiveOrValueOrObject(Class clazz) {
        if (clazz == Object.class) {
            return true;
        }
        JaversType jType = this.getJaversType(clazz);
        return jType instanceof PrimitiveOrValueType || jType instanceof PrimitiveOrValueType;
    }

    private void addType(JaversType jType) {
        this.mappedTypes.put(jType.getBaseJavaType(), jType);
    }

    private JaversType getExactMatchingJaversType(Type javaType) {
        return this.mappedTypes.get(javaType);
    }

    private JaversType createMapping(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        JaversType prototype = this.findNearestAncestor(javaType);
        JaversType newType = prototype == null ? this.typeFactory.infer(javaType) : this.typeFactory.spawnFromPrototype(javaType, prototype);
        this.addType(newType);
        return newType;
    }

    private JaversType findNearestAncestor(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        ArrayList<DistancePair> distances = new ArrayList<DistancePair>();
        for (JaversType javersType : this.mappedTypes.values()) {
            DistancePair distancePair = new DistancePair(javaClass, javersType);
            if (javaClass.isArray()) {
                return this.getJaversType((Type)((Object)Object[].class));
            }
            if (distancePair.getDistance() == 1) {
                return distancePair.getJaversType();
            }
            distances.add(distancePair);
        }
        Collections.sort(distances);
        if (((DistancePair)distances.get(0)).isMax()) {
            return null;
        }
        return ((DistancePair)distances.get(0)).getJaversType();
    }
}

