/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Predicate;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Property;

public abstract class ManagedClass {
    private final Class sourceClass;
    private final List<Property> properties;
    private final List<Property> propertiesUnmodifiable;

    ManagedClass(Class sourceClass, List<Property> properties) {
        Validate.argumentsAreNotNull(sourceClass, properties);
        this.sourceClass = sourceClass;
        this.properties = new ArrayList<Property>(properties);
        this.propertiesUnmodifiable = Collections.unmodifiableList(properties);
    }

    public boolean isInstance(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.sourceClass.isAssignableFrom(cdo.getClass());
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public int hashCode() {
        return this.sourceClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ManagedClass other = (ManagedClass)obj;
        return this.sourceClass.equals(other.sourceClass);
    }

    public String getName() {
        return this.sourceClass.getName();
    }

    public List<Property> getCollectionTypeProperties() {
        return this.getProperties(new Predicate<Property>(){

            @Override
            public boolean apply(Property property) {
                return Collection.class.isAssignableFrom(property.getType());
            }
        });
    }

    public List<Property> getProperties() {
        return this.propertiesUnmodifiable;
    }

    public List<Property> getProperties(Predicate<Property> query) {
        ArrayList<Property> retProperties = new ArrayList<Property>();
        for (Property property : this.properties) {
            if (!query.apply(property)) continue;
            retProperties.add(property);
        }
        return retProperties;
    }

    public Property getProperty(String withName) {
        Property found = null;
        for (Property property : this.properties) {
            if (!property.getName().equals(withName)) continue;
            found = property;
        }
        return found;
    }
}

