/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.property.ManagedClass;

public class Cdo {
    private final Object wrappedCdo;
    private final GlobalCdoId globalId;

    public Cdo(Object wrappedCdo, GlobalCdoId globalId) {
        Validate.argumentsAreNotNull(wrappedCdo, globalId);
        Validate.argumentCheck(globalId.getCdoClass().isInstance(wrappedCdo), "wrappedCdo is not an instance of given managedClass");
        this.globalId = globalId;
        this.wrappedCdo = wrappedCdo;
    }

    public Object getWrappedCdo() {
        return this.wrappedCdo;
    }

    public GlobalCdoId getGlobalId() {
        return this.globalId;
    }

    public Object getLocalId() {
        return this.globalId.getCdoId();
    }

    public ManagedClass getManagedClass() {
        return this.globalId.getCdoClass();
    }

    public String toString() {
        return this.globalId.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Cdo)) {
            return false;
        }
        Cdo other = (Cdo)o;
        return this.globalId.equals(other.globalId);
    }

    public int hashCode() {
        return this.globalId.hashCode();
    }
}

