/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.FakeNodePair;
import org.javers.core.diff.GraphPair;
import org.javers.core.diff.NodeMatcher;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.NodeChangeAppender;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.model.object.graph.ObjectNode;

public class DiffFactory {
    private final NodeMatcher nodeMatcher;
    private final TypeMapper typeMapper;
    private final List<NodeChangeAppender> nodeChangeAppenders;
    private final List<PropertyChangeAppender> propertyChangeAppender;

    public DiffFactory(List<NodeChangeAppender> nodeChangeAppenders, List<PropertyChangeAppender> propertyChangeAppender, TypeMapper typeMapper) {
        this.nodeChangeAppenders = nodeChangeAppenders;
        this.propertyChangeAppender = propertyChangeAppender;
        this.nodeMatcher = new NodeMatcher();
        this.typeMapper = typeMapper;
    }

    public Diff createInitial(String userId, ObjectNode root) {
        Validate.argumentIsNotNull(root);
        GraphPair graphPair = new GraphPair(root);
        return this.createAndAppendChanges(userId, graphPair);
    }

    public Diff create(String userId, ObjectNode leftRoot, ObjectNode rightRoot) {
        Validate.argumentsAreNotNull(leftRoot, rightRoot);
        GraphPair graphPair = new GraphPair(leftRoot, rightRoot);
        return this.createAndAppendChanges(userId, graphPair);
    }

    private Diff createAndAppendChanges(String userId, GraphPair graphPair) {
        Diff diff = new Diff(userId);
        for (NodeChangeAppender appender : this.nodeChangeAppenders) {
            diff.addChanges(appender.getChangeSet(graphPair));
        }
        for (ObjectNode node : graphPair.getOnlyOnRight()) {
            FakeNodePair pair = new FakeNodePair(node);
            this.appendPropertyChanges(diff, pair);
        }
        for (NodePair pair : this.nodeMatcher.match(graphPair)) {
            this.appendPropertyChanges(diff, pair);
        }
        return diff;
    }

    private void appendPropertyChanges(Diff diff, NodePair pair) {
        List<Property> nodeProperties = pair.getProperties();
        for (Property property : nodeProperties) {
            if (pair.isNullOnBothSides(property)) continue;
            JaversType javersType = this.typeMapper.getPropertyType(property);
            for (PropertyChangeAppender appender : this.propertyChangeAppender) {
                Object change = appender.calculateChangesIfSupported(pair, property, javersType);
                if (change == null) continue;
                diff.addChange((Change)change, pair.getRight().getCdo().getWrappedCdo());
            }
        }
    }
}

