/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.javers.common.patterns.visitors.Visitable;
import org.javers.common.validation.Validate;
import org.javers.core.diff.Change;
import org.javers.core.diff.ChangeVisitor;
import org.joda.time.LocalDateTime;

public class Diff
implements Visitable<ChangeVisitor> {
    private long id;
    private final List<Change> changes;
    private final String userId;
    private final LocalDateTime diffDate;

    public Diff(String userId) {
        Validate.argumentIsNotNull(userId, "userId should not be null");
        this.userId = userId;
        this.diffDate = new LocalDateTime();
        this.changes = new ArrayList<Change>();
    }

    public long getId() {
        return this.id;
    }

    void assignId(long id) {
        Validate.argumentCheck(id > 0L, "id should be positive long");
        Validate.conditionFulfilled(this.isNew(), "id already assigned");
        this.id = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public LocalDateTime getDiffDate() {
        return this.diffDate;
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    private boolean isNew() {
        return this.id == 0L;
    }

    public void addChange(Change change, Object affectedCdo) {
        this.addChange(change);
        change.setAffectedCdo(affectedCdo);
    }

    private void addChange(Change change) {
        this.changes.add(change);
    }

    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    public void addChanges(Collection<Change> changeSet) {
        for (Change change : changeSet) {
            this.addChange(change);
        }
    }

    @Override
    public void accept(ChangeVisitor changeVisitor) {
        for (Change change : this.changes) {
            change.accept(changeVisitor);
        }
    }
}

