/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Transient;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;

public class ReflectionUtil {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static List<Method> findAllPersistentGetters(Class methodSource) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : ReflectionUtil.getAllMethods(methodSource)) {
            if (!ReflectionUtil.isPersistentGetter(m)) continue;
            result.add(m);
        }
        return result;
    }

    public static List<Method> getAllMethods(Class methodSource) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class clazz = methodSource; clazz != null; clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                methods.add(m);
            }
        }
        return methods;
    }

    public static boolean isPersistentGetter(Method m) {
        if (!ReflectionUtil.isGetter(m)) {
            return false;
        }
        return !m.isAnnotationPresent(Transient.class) && !Modifier.isAbstract(m.getModifiers()) && !Modifier.isNative(m.getModifiers());
    }

    public static boolean isGetter(Method m) {
        return (m.getName().substring(0, 3).equals("get") || m.getName().substring(0, 2).equals("is")) && m.getParameterTypes().length == 0;
    }

    public static String getterToField(Method getter) {
        if (getter.getName().substring(0, 3).equals("get")) {
            return getter.getName().substring(3, 4).toLowerCase() + getter.getName().substring(4);
        }
        if (getter.getName().substring(0, 2).equals("is")) {
            return getter.getName().substring(2, 3).toLowerCase() + getter.getName().substring(3);
        }
        throw new IllegalArgumentException("Method [" + getter + "] is not getter");
    }

    public static Object invokeGetter(Method getter, Object onObject) {
        try {
            return getter.invoke(onObject, EMPTY_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException("error calling getter '" + getter + "'", e);
        }
    }

    public static Object invokeGetterEvenIfPrivate(Method getter, Object onObject) {
        ReflectionUtil.setAccessibleIfPrivateOrProtected(getter);
        return ReflectionUtil.invokeGetter(getter, onObject);
    }

    public static Object invokeFieldEvenIfPrivate(Field field, Object onObject) {
        ReflectionUtil.setAccessibleIfPrivateOrProtected(field);
        return ReflectionUtil.invokeField(field, onObject);
    }

    public static Object invokeField(Field field, Object onObject) {
        try {
            return field.get(onObject);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error getting unwrap from field '" + field.getName() + "'");
        }
    }

    private static boolean isPrivateOrProtected(int modifiersCode) {
        return Modifier.isPrivate(modifiersCode) || Modifier.isProtected(modifiersCode);
    }

    private static <T extends AccessibleObject> void setAccessibleIfPrivateOrProtected(T object) {
        if (ReflectionUtil.isPrivateOrProtected(((Member)((Object)object)).getModifiers())) {
            object.setAccessible(true);
        }
    }

    public static List<Class> extractActualClassTypeArguments(Type javaType) {
        if (!(javaType instanceof ParameterizedType)) {
            return Collections.emptyList();
        }
        ParameterizedType parameterizedType = (ParameterizedType)javaType;
        ArrayList<Class> result = new ArrayList<Class>();
        for (Type t : parameterizedType.getActualTypeArguments()) {
            if (!(t instanceof Class)) continue;
            result.add((Class)t);
        }
        return Collections.unmodifiableList(result);
    }

    public static Class extractClass(Type javaType) {
        if (javaType instanceof ParameterizedType && ((ParameterizedType)javaType).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)javaType).getRawType();
        }
        if (javaType instanceof Class) {
            return (Class)javaType;
        }
        throw new JaversException(JaversExceptionCode.CLASS_EXTRACTION_ERROR, javaType);
    }

    public static int calculateHierarchyDistance(Class<?> clazz, Class<?> parent) {
        Class<?> current = clazz;
        int distance = 0;
        while (current != null) {
            if (parent == current) {
                return distance;
            }
            for (Class<?> interf : current.getInterfaces()) {
                if (parent != interf) continue;
                return distance + 1;
            }
            current = current.getSuperclass();
            ++distance;
        }
        return Integer.MAX_VALUE;
    }
}

