/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.object.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.property.Entity;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.Property;
import org.javers.model.object.graph.Edge;
import org.javers.model.object.graph.GraphVisitor;
import org.javers.model.object.graph.ObjectNode;

public class ObjectWrapper
extends ObjectNode {
    private final Cdo cdo;
    private final Map<Property, Edge> edges;

    public ObjectWrapper(Cdo cdo) {
        Validate.argumentIsNotNull(cdo);
        this.cdo = cdo;
        this.edges = new HashMap<Property, Edge>();
    }

    public ObjectWrapper(Object cdo, Entity entity) {
        this(new Cdo(cdo, new InstanceId(cdo, entity)));
    }

    public Object unwrapCdo() {
        return this.cdo.getWrappedCdo();
    }

    @Override
    public Cdo getCdo() {
        return this.cdo;
    }

    @Override
    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        return property.get(this.unwrapCdo());
    }

    @Override
    public GlobalCdoId getGlobalCdoId() {
        return this.cdo.getGlobalId();
    }

    @Override
    public ManagedClass getManagedClass() {
        return this.cdo.getManagedClass();
    }

    @Override
    public List<Edge> getEdges() {
        return new ArrayList<Edge>(this.edges.values());
    }

    @Override
    public Edge getEdge(Property property) {
        return this.edges.get(property);
    }

    public void addEdge(Edge edge) {
        this.edges.put(edge.getProperty(), edge);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectWrapper that = (ObjectWrapper)o;
        return this.cdo.equals(that.cdo);
    }

    public int hashCode() {
        return this.cdo.hashCode();
    }

    @Override
    public void accept(GraphVisitor visitor) {
        if (visitor.wasVisited(this)) {
            return;
        }
        visitor.visit(this);
        for (Edge edge : this.edges.values()) {
            edge.accept(visitor);
        }
    }
}

