/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import org.javers.core.diff.changetype.Value;
import org.javers.core.json.JsonTypeAdapter;

public class ValueTypeAdapter
implements JsonTypeAdapter<Value> {
    private boolean typeSafety;

    public ValueTypeAdapter(boolean typeSafety) {
        this.typeSafety = typeSafety;
    }

    @Override
    public JsonElement toJson(Value sourceValue, JsonSerializationContext jsonSerializationContext) {
        if (sourceValue.isNull()) {
            return JsonNull.INSTANCE;
        }
        JsonElement rawValue = jsonSerializationContext.serialize(sourceValue.unwrap());
        if (sourceValue.isJsonBasicType() || !this.typeSafety) {
            return rawValue;
        }
        return this.wrapTypeSafely(sourceValue, jsonSerializationContext);
    }

    private JsonElement wrapTypeSafely(Value sourceValue, JsonSerializationContext jsonSerializationContext) {
        JsonObject element = new JsonObject();
        element.addProperty("typeAlias", sourceValue.unwrap().getClass().getSimpleName());
        element.add("value", jsonSerializationContext.serialize(sourceValue.unwrap()));
        return element;
    }

    @Override
    public Value fromJson(JsonElement json, JsonDeserializationContext jsonDeserializationContext) {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Class getValueType() {
        return Value.class;
    }
}

